/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.module;

import cy.jdkdigital.utilitarian.Config;
import cy.jdkdigital.utilitarian.Utilitarian;
import cy.jdkdigital.utilitarian.common.block.NoSolicitingBanner;
import cy.jdkdigital.utilitarian.common.block.NoSolicitingWallBanner;
import cy.jdkdigital.utilitarian.common.block.SolicitingCarpet;
import cy.jdkdigital.utilitarian.common.block.entity.NoSolicitingBannerBlockEntity;
import cy.jdkdigital.utilitarian.common.item.RestrainingOrder;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.RegistryObject;

public class NoSolicitingModule {
    public static RegistryObject<Block> NO_SOLICITING_BANNER;
    public static RegistryObject<Block> NO_SOLICITING_WALL_BANNER;
    public static Map<DyeColor, RegistryObject<Block>> SOLICITING_CARPET;
    public static Map<DyeColor, RegistryObject<Block>> TRAPPED_SOLICITING_CARPET;
    public static RegistryObject<BlockEntityType<NoSolicitingBannerBlockEntity>> NO_SOLICITING_BANNER_BLOCK_ENTITY;
    public static RegistryObject<Item> NO_SOLICITING_BANNER_ITEM;
    public static Map<DyeColor, RegistryObject<Item>> SOLICITING_CARPET_ITEM;
    public static Map<DyeColor, RegistryObject<Item>> TRAPPED_SOLICITING_CARPET_ITEM;
    public static RegistryObject<Item> RESTRAINING_ORDER;
    public static RegistryObject<PoiType> NO_SOLICITING_POI;
    public static TagKey<EntityType<?>> ENTITY_BLACKLIST;
    public static TagKey<PoiType> NO_SOLICITING_POI_TAG;
    public static TagKey<PoiType> SOLICITING_POI_TAG;
    public static TagKey<Block> TRAPPED_SOLICITING_CARPETS;

    public static void register() {
        NO_SOLICITING_BANNER = Utilitarian.BLOCKS.register("no_soliciting_banner", () -> new NoSolicitingBanner(DyeColor.WHITE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50414_)));
        NO_SOLICITING_WALL_BANNER = Utilitarian.BLOCKS.register("no_soliciting_wall_banner", () -> new NoSolicitingWallBanner(DyeColor.WHITE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50430_)));
        NO_SOLICITING_BANNER_BLOCK_ENTITY = Utilitarian.BLOCK_ENTITY.register("no_soliciting_banner", () -> BlockEntityType.Builder.m_155273_(NoSolicitingBannerBlockEntity::new, (Block[])new Block[]{(Block)NO_SOLICITING_BANNER.get(), (Block)NO_SOLICITING_WALL_BANNER.get()}).m_58966_(null));
        NO_SOLICITING_BANNER_ITEM = Utilitarian.ITEMS.register("no_soliciting_banner", () -> new BannerItem((Block)NO_SOLICITING_BANNER.get(), (Block)NO_SOLICITING_WALL_BANNER.get(), new Item.Properties()));
        for (DyeColor color : DyeColor.values()) {
            SOLICITING_CARPET.put(color, (RegistryObject<Block>)Utilitarian.BLOCKS.register(color.m_7912_() + "_soliciting_carpet", () -> new SolicitingCarpet(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50336_))));
            TRAPPED_SOLICITING_CARPET.put(color, (RegistryObject<Block>)Utilitarian.BLOCKS.register(color.m_7912_() + "_trapped_soliciting_carpet", () -> new SolicitingCarpet(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50336_))));
            SOLICITING_CARPET_ITEM.put(color, (RegistryObject<Item>)Utilitarian.ITEMS.register(color.m_7912_() + "_soliciting_carpet", () -> new BlockItem((Block)SOLICITING_CARPET.get(color).get(), new Item.Properties())));
            TRAPPED_SOLICITING_CARPET_ITEM.put(color, (RegistryObject<Item>)Utilitarian.ITEMS.register(color.m_7912_() + "_trapped_soliciting_carpet", () -> new BlockItem((Block)TRAPPED_SOLICITING_CARPET.get(color).get(), new Item.Properties())));
        }
        RESTRAINING_ORDER = Utilitarian.ITEMS.register("restraining_order", () -> new RestrainingOrder(new Item.Properties().m_41487_(1)));
        NO_SOLICITING_POI = Utilitarian.POI_TYPES.register("no_soliciting", () -> {
            HashSet blockStates = new HashSet();
            blockStates.addAll(((Block)NO_SOLICITING_BANNER.get()).m_49965_().m_61056_());
            blockStates.addAll(((Block)NO_SOLICITING_WALL_BANNER.get()).m_49965_().m_61056_());
            return new PoiType(blockStates, 1, 1);
        });
        NO_SOLICITING_POI = Utilitarian.POI_TYPES.register("soliciting", () -> {
            HashSet blockStates = new HashSet();
            for (DyeColor color : DyeColor.values()) {
                blockStates.addAll(((Block)SOLICITING_CARPET.get(color).get()).m_49965_().m_61056_());
                blockStates.addAll(((Block)TRAPPED_SOLICITING_CARPET.get(color).get()).m_49965_().m_61056_());
            }
            return new PoiType(blockStates, 1, 1);
        });
    }

    public static int locateNearbyNoSoliciting(ServerLevel level, BlockPos spawnPosition) {
        PoiManager poiManager = level.m_8904_();
        Stream stream = poiManager.m_27181_(poi -> poi.m_203656_(NO_SOLICITING_POI_TAG), spawnPosition, (Integer)Config.SERVER.NO_SOLICITING_BANNER_CHUNK_RANGE.get() * 16, PoiManager.Occupancy.ANY);
        List<BlockPos> posList = stream.map(PoiRecord::m_27257_).filter(blockPos -> level.m_8055_(blockPos).m_60713_((Block)NO_SOLICITING_BANNER.get()) || level.m_8055_(blockPos).m_60713_((Block)NO_SOLICITING_WALL_BANNER.get())).toList();
        if (!posList.isEmpty()) {
            return posList.size();
        }
        double range = (double)((Integer)Config.SERVER.NO_SOLICITING_BANNER_CHUNK_RANGE.get()).intValue() * 16.0;
        List<Player> players = level.m_45976_(Player.class, new AABB(new BlockPos((Vec3i)spawnPosition)).m_82377_(range, range, range)).stream().filter(player -> {
            for (ItemStack itemStack : player.m_150109_().f_35974_) {
                if (!RestrainingOrder.isEnabledRestrainingOrder(itemStack)) continue;
                return true;
            }
            return false;
        }).toList();
        return players.size();
    }

    public static List<BlockPos> locateNearbySoliciting(ServerLevel level, BlockPos spawnPosition) {
        PoiManager poiManager = level.m_8904_();
        Stream stream = poiManager.m_27181_(poi -> poi.m_203656_(SOLICITING_POI_TAG), spawnPosition, (Integer)Config.SERVER.SOLICITING_CARPET_CHUNK_RANGE.get() * 16, PoiManager.Occupancy.ANY);
        return stream.map(PoiRecord::m_27257_).sorted(Comparator.comparingDouble(vec -> vec.m_123331_((Vec3i)spawnPosition))).toList();
    }

    static {
        SOLICITING_CARPET = new HashMap<DyeColor, RegistryObject<Block>>();
        TRAPPED_SOLICITING_CARPET = new HashMap<DyeColor, RegistryObject<Block>>();
        SOLICITING_CARPET_ITEM = new HashMap<DyeColor, RegistryObject<Item>>();
        TRAPPED_SOLICITING_CARPET_ITEM = new HashMap<DyeColor, RegistryObject<Item>>();
        ENTITY_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("utilitarian", "traders"));
        NO_SOLICITING_POI_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256805_, (ResourceLocation)new ResourceLocation("utilitarian", "no_soliciting"));
        SOLICITING_POI_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256805_, (ResourceLocation)new ResourceLocation("utilitarian", "soliciting"));
        TRAPPED_SOLICITING_CARPETS = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("utilitarian", "trapped_soliciting_carpets"));
    }
}

