/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CommonConfig {
    public static final ForgeConfigSpec CONFIG;
    private static final CommonConfig INSTANCE;
    public final ForgeConfigSpec.DoubleValue highspeedRailMaxSpeed;
    public final ForgeConfigSpec.DoubleValue highspeedRailAccelOccupied;
    public final ForgeConfigSpec.DoubleValue highspeedRailAccelUnoccupied;
    public final ForgeConfigSpec.DoubleValue speedClampRailSpeed;
    public final ForgeConfigSpec.IntValue teleportRailLogDivisionCost;
    public final ForgeConfigSpec.IntValue teleportRailDimensionCost;

    public static CommonConfig getInstance() {
        return INSTANCE;
    }

    private CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Rail Settings").push("rail");
        builder.comment("High Speed Rail Settings").push("highspeedrail");
        this.highspeedRailMaxSpeed = builder.comment("Maximum Speed for High Speed Rail (default: 5.0 blocks/tick)").defineInRange("highSpeedRailMaxSpeed", 5.0, 0.0, 10.0);
        this.highspeedRailAccelOccupied = builder.comment("Acceleration for High Speed Rail if Occupied (default: 4.0 blocks/tick^2)").defineInRange("highSpeedRailAccelOccupied", 4.0, 0.0, 10.0);
        this.highspeedRailAccelUnoccupied = builder.comment("Acceleration for High Speed Rail if Unoccupied (default: 2.0 blocks/tick^2)").defineInRange("highSpeedRailAccelUnoccupied", 2.0, 0.0, 10.0);
        builder.pop();
        builder.comment("Speed Clamp Rail Settings").push("speedclamprail");
        this.speedClampRailSpeed = builder.comment("Speed for Speed Clamp Rail (default: 0.25 blocks/tick)").defineInRange("speedClampRailSpeed", 0.25, 0.0, 10.0);
        builder.pop();
        builder.comment("Teleport Rail Settings").push("teleportrail");
        this.teleportRailLogDivisionCost = builder.comment("Cost divided by natural log of this value. Lower values increase the cost").defineInRange("teleportRailLogDivisionCost", 5, 2, 100);
        this.teleportRailDimensionCost = builder.comment("Extra cost per dimension teleport").defineInRange("teleportRailDimensionCost", 100, 0, 1000000);
        builder.pop();
        builder.pop();
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        CONFIG = (ForgeConfigSpec)pair.getRight();
        INSTANCE = (CommonConfig)pair.getLeft();
    }
}

