/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.blockentity;

import info.u_team.u_team_core.api.block.MenuSyncedBlockEntity;
import info.u_team.u_team_core.blockentity.UBlockEntity;
import info.u_team.u_team_core.util.LevelUtil;
import info.u_team.useful_railroads.config.CommonConfig;
import info.u_team.useful_railroads.init.UsefulRailroadsBlockEntityTypes;
import info.u_team.useful_railroads.init.UsefulRailroadsRecipeTypes;
import info.u_team.useful_railroads.inventory.FuelItemHandler;
import info.u_team.useful_railroads.menu.TeleportRailMenu;
import info.u_team.useful_railroads.recipe.TeleportRailFuelRecipe;
import info.u_team.useful_railroads.util.Location;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class TeleportRailBlockEntity
extends UBlockEntity
implements MenuSyncedBlockEntity {
    private final Location location = Location.getOrigin();
    private int fuel;
    private int cost;
    private final FuelItemHandler<TeleportRailFuelRecipe> fuelSlot = new FuelItemHandler((RecipeType)UsefulRailroadsRecipeTypes.TELEPORT_RAIL_FUEL.get(), () -> ((TeleportRailBlockEntity)this).m_58904_(), () -> this.fuel < 10000, fuelAdder -> {
        this.fuel += fuelAdder;
        this.m_6596_();
    });
    private final LazyOptional<FuelItemHandler<TeleportRailFuelRecipe>> fuelSlotOptional = LazyOptional.of(() -> this.fuelSlot);

    public TeleportRailBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)UsefulRailroadsBlockEntityTypes.TELEPORT_RAIL.get(), pos, state);
    }

    private void checkCost() {
        if (this.cost == 0) {
            this.cost = this.calculateCost();
        }
    }

    private int calculateCost() {
        int calculatedCost = 0;
        if (!this.location.getResourceKey().equals((Object)this.f_58857_.m_46472_())) {
            calculatedCost += ((Integer)CommonConfig.getInstance().teleportRailDimensionCost.get()).intValue();
        }
        double calculatedDistance = Math.log(this.f_58858_.m_123331_((Vec3i)this.location.getPos())) / Math.log(((Integer)CommonConfig.getInstance().teleportRailLogDivisionCost.get()).intValue());
        if ((calculatedCost += Mth.m_14107_((double)(calculatedDistance *= calculatedDistance))) == 0) {
            return 1;
        }
        return calculatedCost;
    }

    public void teleport(BlockPos pos, AbstractMinecart cart) {
        this.checkCost();
        cart.m_20334_(0.0, 0.0, 0.0);
        Entity entity = cart.m_146895_();
        if (this.fuel < this.cost) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"block.usefulrailroads.teleport_rail.not_enough_fuel", (Object[])new Object[]{this.cost}).m_130940_(ChatFormatting.RED), true);
            }
            return;
        }
        this.fuel -= this.cost;
        this.m_6596_();
        ServerLevel teleportLevel = cart.m_20194_().m_129880_(this.location.getResourceKey());
        if (teleportLevel == null) {
            return;
        }
        cart.m_20194_().m_6937_((Runnable)new TickTask(0, () -> {
            Vec3 teleportPos = Vec3.m_82512_((Vec3i)this.location.getPos());
            Entity newEntity = entity != null ? LevelUtil.teleportEntity((Entity)entity, (ServerLevel)teleportLevel, (Vec3)teleportPos) : null;
            Entity newCart = LevelUtil.teleportEntity((Entity)cart, (ServerLevel)teleportLevel, (Vec3)teleportPos);
            if (newEntity != null) {
                newEntity.m_7998_(newCart, true);
                teleportLevel.m_7726_().m_8394_(newEntity, (Packet)new ClientboundSetPassengersPacket(newCart));
            }
        }));
    }

    public void saveNBT(CompoundTag compound) {
        compound.m_128365_("location", (Tag)this.location.serializeNBT());
        if (this.fuel != 0) {
            compound.m_128405_("fuel", this.fuel);
        }
    }

    public void loadNBT(CompoundTag compound) {
        this.location.deserializeNBT(compound.m_128469_("location"));
        this.fuel = compound.m_128451_("fuel");
    }

    public void sendInitialMenuDataToClient(FriendlyByteBuf buffer) {
        this.checkCost();
        this.location.serialize(buffer);
        buffer.writeInt(this.fuel);
        buffer.writeInt(this.cost);
    }

    public void handleInitialMenuDataFromServer(FriendlyByteBuf buffer) {
        this.location.deserialize(buffer);
        this.fuel = buffer.readInt();
        this.cost = buffer.readInt();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction direction) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && direction != Direction.UP) {
            return this.fuelSlotOptional.cast();
        }
        return super.getCapability(capability, direction);
    }

    public void m_7651_() {
        this.fuelSlotOptional.invalidate();
        super.m_7651_();
    }

    public void onChunkUnloaded() {
        this.fuelSlotOptional.invalidate();
        super.onChunkUnloaded();
    }

    public FuelItemHandler<TeleportRailFuelRecipe> getFuelSlot() {
        return this.fuelSlot;
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new TeleportRailMenu(containerId, playerInventory, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.usefulrailroads.teleport_rail");
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int fuel) {
        this.fuel = fuel;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getCost() {
        return this.cost;
    }
}

