/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.block;

import info.u_team.useful_railroads.block.CustomPoweredRailBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.RailState;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.Fluids;

public class DirectionRailBlock
extends CustomPoweredRailBlock {
    public static final BooleanProperty AXIS_DIRECTION = BooleanProperty.m_61465_((String)"positive_axis");

    public DirectionRailBlock() {
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AXIS_DIRECTION, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        if (!((Boolean)state.m_61143_((Property)PoweredRailBlock.f_55215_)).booleanValue()) {
            return;
        }
        RailShape shape = this.getRailDirection(state, (BlockGetter)level, pos, cart);
        boolean positiveAxis = (Boolean)state.m_61143_((Property)AXIS_DIRECTION);
        if (shape == RailShape.EAST_WEST) {
            cart.m_20334_(positiveAxis ? 0.6 : -0.6, cart.m_20184_().m_7098_(), cart.m_20184_().m_7094_());
        } else if (shape == RailShape.NORTH_SOUTH) {
            cart.m_20334_(cart.m_20184_().m_7096_(), cart.m_20184_().m_7098_(), positiveAxis ? 0.6 : -0.6);
        }
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    protected BlockState m_49367_(final Level level, final BlockPos pos, BlockState updateState, boolean placing) {
        return level.f_46443_ ? updateState : new RailState(level, pos, updateState){

            public RailState m_55431_(boolean powered, boolean placing, RailShape unused) {
                boolean hasRailNorth = this.m_55446_(pos.m_122012_());
                boolean hasRailSouth = this.m_55446_(pos.m_122019_());
                boolean hasRailWest = this.m_55446_(pos.m_122024_());
                boolean hasRailEast = this.m_55446_(pos.m_122029_());
                RailShape shape = null;
                if ((hasRailNorth || hasRailSouth) && !hasRailWest && !hasRailEast) {
                    shape = RailShape.NORTH_SOUTH;
                }
                if ((hasRailWest || hasRailEast) && !hasRailNorth && !hasRailSouth) {
                    shape = RailShape.EAST_WEST;
                }
                if (shape == null) {
                    shape = (RailShape)this.f_55417_.m_61143_((Property)PoweredRailBlock.f_55214_);
                }
                this.m_55427_(shape);
                this.f_55417_ = (BlockState)this.f_55417_.m_61124_((Property)PoweredRailBlock.f_55214_, (Comparable)shape);
                if (placing || level.m_8055_(pos) != this.f_55417_) {
                    level.m_7731_(pos, this.f_55417_, 3);
                    for (BlockPos connection : this.f_55419_) {
                        RailState railstate = this.m_55438_(connection);
                        if (railstate == null) continue;
                        railstate.m_55445_();
                        if (!railstate.m_55436_((RailState)this)) continue;
                        railstate.m_55441_((RailState)this);
                    }
                }
                return this;
            }
        }.m_55431_(level.m_276867_(pos), placing, null).m_55440_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        boolean isWater = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AXIS_DIRECTION, (Comparable)Boolean.valueOf(direction.m_122421_() == Direction.AxisDirection.POSITIVE))).m_61124_((Property)f_55214_, (Comparable)(direction.m_122434_() == Direction.Axis.Z ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST))).m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(isWater));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AXIS_DIRECTION});
    }
}

