/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class ItemIngredient
extends Ingredient {
    private final int amount;

    public static ItemIngredient fromItems(int amount, ItemLike ... items) {
        return new ItemIngredient(amount, Arrays.stream(items).map(item -> new Ingredient.ItemValue(new ItemStack(item))));
    }

    public static ItemIngredient fromStacks(int amount, ItemStack ... stacks) {
        return new ItemIngredient(amount, Arrays.stream(stacks).map(stack -> new Ingredient.ItemValue(stack)));
    }

    public static ItemIngredient fromTag(int amount, TagKey<Item> tag) {
        return new ItemIngredient(amount, Stream.of(new Ingredient.TagValue(tag)));
    }

    protected ItemIngredient(int amount, Stream<? extends Ingredient.Value> stream) {
        super(stream);
        this.amount = amount;
    }

    public boolean test(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.f_43902_.length == 0) {
            return stack.m_41619_();
        }
        for (ItemStack itemstack : this.f_43903_) {
            if (itemstack.m_41720_() != stack.m_41720_()) continue;
            return stack.m_41613_() >= this.amount;
        }
        return false;
    }

    public int getAmount() {
        return this.amount;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        jsonObject.addProperty("amount", (Number)this.amount);
        jsonObject.add("items", super.m_43942_());
        return jsonObject;
    }

    public static class Serializer
    implements IIngredientSerializer<ItemIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public ItemIngredient parse(JsonObject jsonObject) {
            if (!jsonObject.has("amount") || !jsonObject.has("items")) {
                throw new JsonSyntaxException("Expected amount and items");
            }
            int amount = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"amount");
            JsonElement ingredientJsonElement = jsonObject.get("items");
            if (ingredientJsonElement.isJsonObject()) {
                return new ItemIngredient(amount, Stream.of(Ingredient.m_43919_((JsonObject)ingredientJsonElement.getAsJsonObject())));
            }
            if (ingredientJsonElement.isJsonArray()) {
                JsonArray jsonArray = ingredientJsonElement.getAsJsonArray();
                if (jsonArray.size() == 0) {
                    throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
                }
                return new ItemIngredient(amount, StreamSupport.stream(jsonArray.spliterator(), false).map(jsonArrayElement -> Ingredient.m_43919_((JsonObject)GsonHelper.m_13918_((JsonElement)jsonArrayElement, (String)"item"))));
            }
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }

        public ItemIngredient parse(FriendlyByteBuf buffer) {
            int amount = buffer.readInt();
            int length = buffer.m_130242_();
            return new ItemIngredient(amount, Stream.generate(() -> new Ingredient.ItemValue(buffer.m_130267_())).limit(length));
        }

        public void write(FriendlyByteBuf buffer, ItemIngredient ingredient) {
            ItemStack[] items = ingredient.m_43908_();
            buffer.writeInt(ingredient.amount);
            buffer.m_130130_(items.length);
            for (ItemStack stack : items) {
                buffer.m_130055_(stack);
            }
        }
    }
}

