/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractSliderLogic
extends AbstractSliderButton {
    protected static final OnSliderChange EMPTY_SLIDER = slider -> {};
    protected final Component prefix;
    protected final Component suffix;
    protected final double minValue;
    protected final double maxValue;
    protected final boolean decimalPrecision;
    protected int precision = 1;
    protected final boolean drawDescription;
    protected OnSliderChange slider;

    protected AbstractSliderLogic(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double currentValue, boolean decimalPrecision, boolean drawDescription, OnSliderChange slider) {
        super(x, y, width, height, (Component)Component.m_237119_(), 0.0);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.f_93577_ = this.clampValues((currentValue - minValue) / (maxValue - minValue));
        this.decimalPrecision = decimalPrecision;
        this.drawDescription = drawDescription;
        if (drawDescription) {
            String displayValue;
            if (decimalPrecision) {
                displayValue = Double.toString(this.f_93577_ * (maxValue - minValue) + minValue);
                this.precision = Math.min(displayValue.substring(displayValue.indexOf(".") + 1).length(), 4);
            } else {
                displayValue = Integer.toString((int)Math.round(this.f_93577_ * (maxValue - minValue) + minValue));
                this.precision = 0;
            }
            this.m_93666_((Component)Component.m_237119_().m_7220_(prefix).m_130946_(displayValue).m_7220_(suffix));
        } else {
            this.m_93666_((Component)Component.m_237119_());
        }
        this.slider = slider;
    }

    public void setSlider(OnSliderChange slider) {
        this.slider = slider;
    }

    public void setSlider(Runnable runnable) {
        this.slider = slider -> runnable.run();
    }

    protected void m_5695_() {
        this.updateSliderText();
    }

    protected void m_5697_() {
        this.slider.onChange(this);
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.f_93623_ && this.f_93624_) {
            super.m_7212_(mouseX, mouseY, dragX, dragY);
        }
    }

    public void updateSliderText() {
        Object displayValue;
        if (this.decimalPrecision) {
            displayValue = Double.toString(this.f_93577_ * (this.maxValue - this.minValue) + this.minValue);
            if (((String)displayValue).substring(((String)displayValue).indexOf(".") + 1).length() > this.precision) {
                if (((String)(displayValue = ((String)displayValue).substring(0, ((String)displayValue).indexOf(".") + this.precision + 1))).endsWith(".")) {
                    displayValue = ((String)displayValue).substring(0, ((String)displayValue).indexOf(".") + this.precision);
                }
            } else {
                while (((String)displayValue).substring(((String)displayValue).indexOf(".") + 1).length() < this.precision) {
                    displayValue = (String)displayValue + "0";
                }
            }
        } else {
            displayValue = Integer.toString((int)Math.round(this.f_93577_ * (this.maxValue - this.minValue) + this.minValue));
        }
        if (this.drawDescription) {
            this.m_93666_((Component)Component.m_237119_().m_7220_(this.prefix).m_130946_((String)displayValue).m_7220_(this.suffix));
        }
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public double getValue() {
        return this.f_93577_ * (this.maxValue - this.minValue) + this.minValue;
    }

    public void m_93611_(double newValue) {
        this.f_93577_ = this.clampValues((newValue - this.minValue) / (this.maxValue - this.minValue));
        this.updateSliderText();
    }

    private double clampValues(double value) {
        return Mth.m_14008_((double)value, (double)0.0, (double)1.0);
    }

    public static interface OnSliderChange {
        public void onChange(AbstractSliderLogic var1);
    }
}

