/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.tileentity.BlockEntityPlayerGrave;
import ovh.corail.tombstone.tileentity.BlockWritableGrave;

@OnlyIn(value=Dist.CLIENT)
public final class RenderWritableGrave<T extends BlockWritableGrave>
implements BlockEntityRenderer<T> {
    private static final ResourceLocation TEXTURE_SKELETON_HEAD = new ResourceLocation("minecraft", "textures/entity/skeleton/skeleton.png");
    private final Map<SkullBlock.Type, SkullModelBase> skullModels;

    public RenderWritableGrave(BlockEntityRendererProvider.Context context) {
        this.skullModels = SkullBlockRenderer.m_173661_((EntityModelSet)context.m_173585_());
    }

    public void render(T te, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int destroyStage) {
        TimeHelper.SpecialEvent specialEvent;
        BlockEntityPlayerGrave grave;
        if (te.m_58904_() == null) {
            return;
        }
        if (te instanceof BlockEntityPlayerGrave && !(grave = (BlockEntityPlayerGrave)((Object)te)).getNeedAccess()) {
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            BlockState web = Blocks.f_50033_.m_49966_();
            BlockRenderDispatcher rendererDispatcher = Minecraft.m_91087_().m_91289_();
            rendererDispatcher.m_110912_(web, poseStack, multiBufferSource, 0xF000F0, OverlayTexture.f_118083_);
            poseStack.m_252880_(1.0f, 0.0f, 1.0f);
            rendererDispatcher.m_110912_(web, poseStack, multiBufferSource, 0xF000F0, OverlayTexture.f_118083_);
            poseStack.m_85849_();
        }
        switch ((ConfigTombstone.Client.GraveSkinRule)((Object)ConfigTombstone.client.graveSkinRule.get())) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case FORCE_NORMAL: {
                TimeHelper.SpecialEvent specialEvent2 = TimeHelper.SpecialEvent.NONE;
                break;
            }
            case FORCE_HALLOWEEN: {
                TimeHelper.SpecialEvent specialEvent2 = TimeHelper.SpecialEvent.HALLOWEEN;
                break;
            }
            case FORCE_CHRISTMAS: {
                TimeHelper.SpecialEvent specialEvent2 = TimeHelper.SpecialEvent.CHRISTMAS;
                break;
            }
            case DEFAULT: {
                TimeHelper.SpecialEvent specialEvent2 = specialEvent = Optional.of(TimeHelper.getSpecialEvent()).filter(e -> e != TimeHelper.SpecialEvent.APRIL_FOOLS).orElse(TimeHelper.SpecialEvent.NONE);
            }
        }
        if (!((BlockWritableGrave)((Object)te)).hasOwner() && specialEvent == TimeHelper.SpecialEvent.NONE) {
            return;
        }
        BlockState knownState = te.m_58904_().m_8055_(te.m_58899_());
        if (!ModBlocks.isAnyGrave(knownState.m_60734_())) {
            return;
        }
        Direction facing = (Direction)knownState.m_61143_((Property)BlockStateProperties.f_61374_);
        BlockGraveBase grave2 = (BlockGraveBase)knownState.m_60734_();
        GraveModel graveModel = grave2.getGraveType();
        BlockGraveMarble.MarbleType marbleType = BlockGraveMarble.MarbleType.byId((Integer)knownState.m_61143_((Property)BlockGraveBase.MODEL_TEXTURE));
        if (specialEvent != TimeHelper.SpecialEvent.NONE) {
            this.renderSpecial(poseStack, multiBufferSource, graveModel, marbleType, facing, light, Helper.isNight(te.m_58904_()), specialEvent == TimeHelper.SpecialEvent.HALLOWEEN);
        }
        if (!((BlockWritableGrave)((Object)te)).hasOwner()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.0f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f * (float)(this.getRotationIndex(facing) - 2)));
        if (graveModel == GraveModel.GRAVE_CROSS) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_252880_(0.0f, 0.26f, -0.07f);
        } else {
            poseStack.m_252781_(Axis.f_252495_.m_252977_(180.0f));
            switch (graveModel) {
                case GRAVE_SIMPLE: {
                    poseStack.m_252880_(0.0f, -0.4f, 0.29f);
                    break;
                }
                case GRAVE_NORMAL: {
                    poseStack.m_252880_(0.0f, -0.5f, 0.36f);
                    break;
                }
                case TOMBSTONE: {
                    poseStack.m_252880_(0.0f, -0.23f, -0.08f);
                    break;
                }
                case SUBARAKI_GRAVE: {
                    poseStack.m_252880_(0.0f, -0.62f, -0.14f);
                    break;
                }
                case GRAVE_ORIGINAL: {
                    poseStack.m_252880_(0.0f, -0.2f, -0.51f);
                    break;
                }
            }
        }
        Font fontRender = Minecraft.m_91087_().f_91062_;
        boolean is_original = graveModel == GraveModel.GRAVE_ORIGINAL;
        this.showString((Component)LangKey.MESSAGE_RIP.getText(ChatFormatting.BOLD, new Object[0]), poseStack, fontRender, is_original ? 8 : 0, (Integer)ConfigTombstone.client.textColorRIP.get() + -16777216, 0.007f, multiBufferSource, light);
        this.showString((Component)Component.m_237113_((String)((BlockWritableGrave)((Object)te)).getOwnerName()), poseStack, fontRender, is_original ? 14 : 11, (Integer)ConfigTombstone.client.textColorOwner.get() + -16777216, 0.005f, multiBufferSource, light);
        float scaleForDate = (Boolean)ConfigTombstone.client.dateInMCTime.get() != false ? 0.005f : 0.004f;
        this.showString((Component)LangKey.MESSAGE_DIED_ON.getText(new Object[0]), poseStack, fontRender, 26, (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216, scaleForDate, multiBufferSource, light);
        if (((Boolean)ConfigTombstone.client.dateInMCTime.get()).booleanValue()) {
            long days = ((BlockWritableGrave)((Object)te)).getDeathMCTime() / 24000L;
            MutableComponent dateString = LangKey.MESSAGE_DAY.getText(days);
            this.showString((Component)dateString, poseStack, fontRender, 36, (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216, scaleForDate, multiBufferSource, light);
        } else {
            Date date = new Date(((BlockWritableGrave)((Object)te)).getOwnerDeathTime());
            MutableComponent dateString = Component.m_237113_((String)new SimpleDateFormat("dd/MM/yyyy").format(date));
            MutableComponent timeString = LangKey.MESSAGE_DEATH_TIME.getText(new SimpleDateFormat("HH:mm:ss").format(date));
            this.showString((Component)dateString, poseStack, fontRender, 36, (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216, scaleForDate, multiBufferSource, light);
            this.showString((Component)timeString, poseStack, fontRender, 46, (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216, scaleForDate, multiBufferSource, light);
        }
        poseStack.m_85849_();
    }

    private void showString(Component content, PoseStack poseStack, Font fontRenderer, int posY, int color, float scale, MultiBufferSource multiBufferSource, int light) {
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        FormattedCharSequence formattedCharSequence = FontHelper.canBeFantasy(content.getString()) ? FontHelper.withFantasyFont(content).m_7532_() : content.m_7532_();
        fontRenderer.m_272191_(formattedCharSequence, (float)(-fontRenderer.m_92724_(formattedCharSequence)) / 2.0f, (float)(posY - 30), color, false, poseStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.POLYGON_OFFSET, 0, light);
        poseStack.m_85849_();
    }

    private void renderSpecial(PoseStack poseStack, MultiBufferSource iRenderTypeBuffer, GraveModel graveModel, BlockGraveMarble.MarbleType marbleType, Direction facing, int light, boolean isNight, boolean isHalloween) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.0f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f * (float)this.getRotationIndex(facing)));
        if (graveModel == GraveModel.GRAVE_NORMAL || graveModel == GraveModel.GRAVE_SIMPLE) {
            if (graveModel == GraveModel.GRAVE_SIMPLE) {
                poseStack.m_252880_(0.0f, isHalloween ? 0.21f : 0.17f, 0.0f);
            } else {
                poseStack.m_252880_(0.0f, isHalloween ? 0.41f : 0.43f, 0.0f);
            }
            float scale = 0.2f;
            poseStack.m_85841_(scale, scale, scale);
            ItemStack stack = isHalloween ? new ItemStack((ItemLike)(isNight ? Blocks.f_50144_ : Blocks.f_50133_)) : this.getStackForChristmas(marbleType);
            Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemDisplayContext.NONE, false, poseStack, iRenderTypeBuffer, 0xF000F0, OverlayTexture.f_118083_, Minecraft.m_91087_().m_91291_().m_174264_(stack, null, null, 0));
        } else if (graveModel == GraveModel.TOMBSTONE) {
            poseStack.m_252880_(-0.2f, isHalloween ? 0.65f : 0.74f, -0.2f);
            float scale = isHalloween ? 0.4f : 0.2f;
            poseStack.m_85841_(scale, scale, scale);
            if (isHalloween) {
                Block block = marbleType == BlockGraveMarble.MarbleType.DARK ? Blocks.f_50681_ : Blocks.f_50682_;
                Minecraft.m_91087_().m_91289_().m_110912_(block.m_49966_(), poseStack, iRenderTypeBuffer, 0xF000F0, OverlayTexture.f_118083_);
            } else {
                ItemStack stack = this.getStackForChristmas(marbleType);
                Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemDisplayContext.NONE, false, poseStack, iRenderTypeBuffer, 0xF000F0, OverlayTexture.f_118083_, Minecraft.m_91087_().m_91291_().m_174264_(stack, null, null, 0));
            }
        } else {
            if (graveModel == GraveModel.SUBARAKI_GRAVE) {
                poseStack.m_252880_(isHalloween ? -0.35f : 0.0f, isHalloween ? 0.44f : 0.22f, -0.35f);
            } else if (graveModel == GraveModel.GRAVE_CROSS) {
                poseStack.m_252880_(0.2f, isHalloween ? 0.07f : 0.15f, -0.1f);
            } else {
                poseStack.m_252880_(isHalloween ? -0.575f : -0.34f, isHalloween ? 0.07f : 0.19f, -0.35f);
            }
            float scale = isHalloween ? 0.3f : 0.2f;
            poseStack.m_85841_(scale, scale, scale);
            if (isHalloween) {
                SkullBlockRenderer.m_173663_(null, (float)0.0f, (float)0.0f, (PoseStack)poseStack, (MultiBufferSource)iRenderTypeBuffer, (int)(isNight ? 0xF000F0 : light), (SkullModelBase)this.skullModels.get(SkullBlock.Types.SKELETON), (RenderType)RenderType.m_110464_((ResourceLocation)TEXTURE_SKELETON_HEAD));
            } else {
                ItemStack stack = this.getStackForChristmas(marbleType);
                Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemDisplayContext.NONE, false, poseStack, iRenderTypeBuffer, 0xF000F0, OverlayTexture.f_118083_, Minecraft.m_91087_().m_91291_().m_174264_(stack, null, null, 0));
            }
        }
        poseStack.m_85849_();
    }

    private ItemStack getStackForChristmas(BlockGraveMarble.MarbleType marbleType) {
        return new ItemStack((ItemLike)(marbleType == BlockGraveMarble.MarbleType.DARK ? ModItems.christmas_gift : ModItems.villager_gift));
    }

    private int getRotationIndex(Direction facing) {
        return switch (facing) {
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 1;
            case Direction.EAST -> 3;
            default -> 0;
        };
    }
}

