/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.combine.TooltipEngravable;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfAssistance
extends ItemTablet {
    private TooltipComponent tooltip;

    public ItemTabletOfAssistance() {
        super("tablet_of_assistance", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfAssistance.get());
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        Component displayName = super.m_7626_(stack);
        if (tooltip.size() > 0) {
            tooltip.set(0, displayName);
        } else {
            tooltip.add(displayName);
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        boolean isAncient = this.isAncient(stack);
        boolean isEnchant = this.isEnchanted(stack);
        if (isAncient) {
            this.addItemDesc(tooltip, "_ancient", new Object[0]);
            if (isEnchant) {
                this.addItemUse(tooltip, "_ancient", new Object[0]);
            } else {
                this.addItemUse(tooltip, "1", new Object[0]);
            }
        } else if (!isEnchant) {
            this.addItemDesc(tooltip);
            this.addItemUse(tooltip, "1", new Object[0]);
        } else {
            String engraved_name = EngravableHelper.getEngravedName(stack);
            if (engraved_name.isEmpty()) {
                this.addItemDesc(tooltip);
                this.addItemUse(tooltip, "2", new Object[0]);
            } else {
                this.addInfo(tooltip, LangKey.MESSAGE_ENGRAVED, "\"" + engraved_name + "\"");
                this.addItemUse(tooltip, "3", new Object[0]);
            }
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    public Component getHighlightTip(ItemStack stack, Component displayName) {
        return super.m_7626_(stack).m_6879_().m_130948_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    public Component m_7626_(ItemStack stack) {
        return Component.m_237113_((String)EngravableHelper.getEngravedName(stack));
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        if (this.tooltip == null) {
            this.tooltip = new TooltipEngravable(new ItemStack((ItemLike)ModItems.grave_dust));
        }
        return this.isEnchanted(stack) && EngravableHelper.getEngravedName(stack).isEmpty() ? Optional.of(this.tooltip) : Optional.empty();
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.m_150930_((Item)this) && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.m_150930_((Item)this)) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            this.setUseCount(stack, this.getUseMax());
            if (!this.isAncient(stack) && soulStrength > 1) {
                NBTStackHelper.setBoolean(stack, "ancient", true);
                return ISoulConsumer.ConsumeResult.success(2);
            }
            return ISoulConsumer.ConsumeResult.success(1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerLevel world, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        String engraved_name = EngravableHelper.getEngravedName(stack);
        if (engraved_name.isEmpty()) {
            boolean isAncient = this.isAncient(stack);
            if (!isAncient) {
                LangKey.MESSAGE_PLAYER_INVALID.sendMessage((Player)player, new Object[0]);
                return false;
            }
            List<ServerPlayer> receivers = world.m_7654_().m_6846_().m_11314_().stream().filter(p -> !p.equals((Object)player)).toList();
            if (receivers.size() == 0) {
                LangKey.MESSAGE_NO_OTHER_VALID_PLAYER.sendMessage((Player)player, new Object[0]);
                return false;
            }
            for (ServerPlayer receiver : receivers) {
                LangKey.MESSAGE_REQUEST_TO_HELP_SENDER.sendSpecialMessage((Player)receiver, LangKey.MESSAGE_HERE.createComponentCommand("/tbacceptteleport " + player.m_36316_().getId(), new Object[0]), player.m_7755_());
                CommandTBAcceptTeleport.addTicket((Player)receiver, (Player)player, 120, false);
            }
            LangKey.MESSAGE_CALL_FOR_HELP.sendMessage((Player)player, new Object[0]);
            ModTriggers.USE_ASSISTANCE.trigger(player);
            return true;
        }
        if (engraved_name.equals(player.m_7755_().getString())) {
            LangKey.MESSAGE_TELEPORT_SAME_PLAYER.sendMessage((Player)player, new Object[0]);
            return false;
        }
        if (Stream.of(world.m_7654_().m_7641_()).noneMatch(p -> p.equals(engraved_name))) {
            if (world.m_7654_().m_129927_().f_10966_.containsKey(engraved_name)) {
                LangKey.MESSAGE_PLAYER_OFFLINE.sendMessage((Player)player, new Object[0]);
            } else {
                LangKey.MESSAGE_PLAYER_INVALID.sendMessage((Player)player, new Object[0]);
            }
            return false;
        }
        ServerPlayer receiver = world.m_7654_().m_6846_().m_11255_(engraved_name);
        if (receiver == null) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendMessage((Player)player, new Object[0]);
            return false;
        }
        if (!receiver.m_9236_().m_46472_().equals((Object)player.m_9236_().m_46472_()) && !((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue()) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        LangKey.MESSAGE_REQUEST_TO_JOIN_RECEIVER.sendSpecialMessage((Player)receiver, LangKey.MESSAGE_HERE.createComponentCommand("/tbacceptteleport " + player.m_36316_().getId(), new Object[0]), player.m_7755_());
        CommandTBAcceptTeleport.addTicket((Player)receiver, (Player)player, 120);
        LangKey.MESSAGE_REQUEST_TO_JOIN_SENDER.sendMessage((Player)player, receiver.m_7755_());
        ModTriggers.USE_ASSISTANCE.trigger(player);
        return true;
    }

    @Override
    protected boolean canBlockInteractFirst(Level level, BlockPos pos, ItemStack stack) {
        return super.canBlockInteractFirst(level, pos, stack) || level.m_8055_(pos).m_204336_(BlockTags.f_13033_);
    }
}

