/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemMagicScroll
extends ItemScroll
implements IDelayedNBTLoot {
    private static final String MAGIC_EFFECT_NBT_TAG = "magic_effect";

    public ItemMagicScroll() {
        super("magic_scroll", ItemMagicScroll.getBuilder().m_41487_(64), () -> SharedConfigTombstone.allowed_magic_items.allowMagicScroll.get());
    }

    @Override
    public Component m_7626_(ItemStack stack) {
        return this.getMagicEffectName(stack).map(effectName -> Component.m_237110_((String)("tombstone.item." + (this.isAncient(stack) ? "ancient_" : "enchanted_") + "scroll_of"), (Object[])new Object[]{effectName}).m_6270_(StyleType.MESSAGE_SPECIAL)).orElse(super.m_7626_(stack));
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        this.getMagicEffect(stack).ifPresent(effectInstance -> {
            this.addEffectInfo(tooltip, effectInstance.m_19544_());
            tooltip.add((Component)(this.isAncient(stack) ? LangKey.MESSAGE_AREA_BUFF : LangKey.MESSAGE_USEABLE_ON_ALLY).getText(new Object[0]).m_130948_(StyleType.EFFECT_DESCRIPTION));
            this.addItemUse(tooltip, LangKey.ITEM_SCROLL_BUFF_USE2, new Object[0]);
            Optional.ofNullable(RegistryHelper.getRegistryName(effectInstance.m_19544_())).map(ResourceLocation::m_135827_).flatMap(modid -> ModList.get().getModContainerById(modid).map(ModContainer::getModInfo).map(IModInfo::getDisplayName)).ifPresent(modName -> tooltip.add((Component)Component.m_237113_((String)"[effect added by %s]".formatted(modName)).m_130948_(StyleType.EFFECT_DESCRIPTION)));
            if (!effectInstance.m_19544_().m_8093_()) {
                tooltip.add((Component)Component.m_237113_((String)("(" + StringUtil.m_14404_((int)Mth.m_14143_((float)((float)((Integer)SharedConfigTombstone.magic_item.scrollDuration.get()).intValue() * (1.0f + (float)EntityHelper.getPerkLevelWithBonus(ModTombstone.PROXY.getClientPlayer(), ModPerks.rune_inscriber) * 0.1f)))) + ")")).m_6270_(StyleType.MESSAGE_SPELL));
            }
        });
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.m_5776_() && stack.m_150930_((Item)this) && this.getMagicEffectName(stack).isEmpty() && TimeHelper.atInterval(entity, TimeHelper.tickFromMinute(1))) {
            this.setMagicEffect(stack);
        }
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canEnchant(Level level, BlockPos gravePos, Player player, ItemStack stack) {
        return false;
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerLevel level, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        @Nullable MobEffectInstance effectInstance = this.getMagicEffect(stack).orElse(null);
        if (effectInstance == null) {
            return false;
        }
        MutableComponent effectName = effectInstance.m_19544_().m_19482_().m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
        effectInstance.f_19503_ = Mth.m_14143_((float)((float)effectInstance.f_19503_ * (1.0f + (float)EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.rune_inscriber) * 0.1f)));
        if (this.isAncient(stack)) {
            List<LivingEntity> allies = level.m_6249_((Entity)player, player.m_20191_().m_82377_(3.0, 0.0, 3.0), e -> e != null && e.m_6084_()).stream().filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).filter(e -> this.isTargetForCasting((Player)player, (LivingEntity)e)).toList();
            allies.forEach(arg_0 -> ItemMagicScroll.lambda$doEffects$6(effectInstance, (Component)effectName, arg_0));
            ModTriggers.CAST_ON_ALLY.trigger(player, allies.size());
            EffectHelper.addEffect((LivingEntity)player, new MobEffectInstance(effectInstance));
            LangKey.MESSAGE_SPELL_CAST_AROUND.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{effectName});
        } else {
            if (target == null) {
                target = player;
            }
            EffectHelper.addEffect(target, new MobEffectInstance(effectInstance));
            if (EntityHelper.isValidServerPlayer((Entity)target)) {
                LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((Player)((ServerPlayer)target), StyleType.MESSAGE_SPELL, new Object[]{effectName});
            }
            if (!target.equals((Object)player)) {
                ModTriggers.CAST_ON_ALLY.trigger(player);
                LangKey.MESSAGE_SPELL_CAST_ON_TARGET.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{effectName, target.m_7755_().m_6879_().m_6270_(StyleType.TOOLTIP_ITEM)});
            }
        }
        return true;
    }

    public Optional<Component> getMagicEffectName(ItemStack stack) {
        CompoundTag tagEffect;
        MobEffect effect;
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_(MAGIC_EFFECT_NBT_TAG, 10) && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation((tagEffect = stack.m_41783_().m_128469_(MAGIC_EFFECT_NBT_TAG)).m_128461_("id")))) != null) {
            int amplifier = tagEffect.m_128445_("amplifier") & 0xFF;
            if (amplifier > 0) {
                return Optional.of(effect.m_19482_().m_6881_().m_130946_(" " + EffectHelper.getPotency(amplifier + 1)));
            }
            return Optional.of(effect.m_19482_());
        }
        return Optional.empty();
    }

    public Optional<MobEffectInstance> getMagicEffect(ItemStack stack) {
        CompoundTag tagEffect;
        MobEffect effect;
        if (stack.m_150930_((Item)this) && stack.m_41783_() != null && stack.m_41783_().m_128425_(MAGIC_EFFECT_NBT_TAG, 10) && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation((tagEffect = stack.m_41783_().m_128469_(MAGIC_EFFECT_NBT_TAG)).m_128461_("id")))) != null) {
            Function<MobEffect, Integer> duration = e -> e.m_8093_() ? 1 : (Integer)SharedConfigTombstone.magic_item.scrollDuration.get();
            return Optional.of(new MobEffectInstance(effect, duration.apply(effect).intValue(), tagEffect.m_128445_("amplifier") & 0xFF));
        }
        return Optional.empty();
    }

    public ItemStack setMagicEffect(ItemStack stack) {
        MobEffect effect;
        if (stack.m_150930_((Item)this) && (effect = (MobEffect)Helper.getRandomInList(ForgeRegistries.MOB_EFFECTS.getEntries().stream().filter(entry -> !((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals("tombstone")).map(Map.Entry::getValue).filter(EffectHelper::isAllowedEffect).toList()).orElse(null)) != null) {
            int amplifier = EffectHelper.RANDOM_EFFECT_LEVEL.apply(Helper.RANDOM);
            CompoundTag tagEffect = new CompoundTag();
            tagEffect.m_128359_("id", RegistryHelper.getRegistryString(effect));
            tagEffect.m_128344_("amplifier", (byte)amplifier);
            stack.m_41784_().m_128365_(MAGIC_EFFECT_NBT_TAG, (Tag)tagEffect);
        }
        return stack;
    }

    public int getColor(ItemStack stack, int tint) {
        CompoundTag tagEffect;
        MobEffect effect;
        if ((tint == 1 || tint == 2) && stack.m_41783_() != null && stack.m_41783_().m_128425_(MAGIC_EFFECT_NBT_TAG, 10) && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation((tagEffect = stack.m_41783_().m_128469_(MAGIC_EFFECT_NBT_TAG)).m_128461_("id")))) != null) {
            if (tint == 2) {
                return effect.m_19484_();
            }
            float[] colors = Helper.getRGBColor3F(effect.m_19484_());
            if (IntStream.range(0, colors.length).allMatch(i -> colors[i] > 0.8f)) {
                return 65536 * (int)((1.0f - colors[0]) * 255.0f) + 256 * (int)((1.0f - colors[1]) * 255.0f) + (int)((1.0f - colors[2]) * 255.0f);
            }
        }
        return -1;
    }

    @Override
    protected boolean canAffectTarget(ItemStack stack, LivingEntity target) {
        return !this.isAncient(stack) && this.getMagicEffect(stack).map(e -> (!EntityHelper.isUndead(target) || e.m_19544_() != MobEffects.f_19601_) && target.m_7301_(e)).orElse(false) != false;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundTag tag, LootContext context) {
        return this.setMagicEffect(stack);
    }

    public ItemStack createAncient() {
        return NBTStackHelper.setBoolean(new ItemStack((ItemLike)this), "ancient", true);
    }

    private static /* synthetic */ void lambda$doEffects$6(MobEffectInstance effectInstance, Component effectName, LivingEntity e) {
        EffectHelper.addEffect(e, new MobEffectInstance(effectInstance));
        if (EntityHelper.isValidServerPlayer((Entity)e)) {
            LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((Player)((ServerPlayer)e), StyleType.MESSAGE_SPELL, new Object[]{effectName});
        }
    }
}

