/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.gui;

import com.dannyandson.tinyredstone.blocks.ChopperBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ChopperItemHandler
implements IItemHandler {
    private ChopperBlockEntity innerHandler;

    public ChopperItemHandler(ChopperBlockEntity innerHandler) {
        this.innerHandler = innerHandler;
    }

    public int getSlots() {
        return 2;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return slot == 0 ? this.innerHandler.m_8020_(slot) : this.innerHandler.getResultContainer().m_8020_(0);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (slot > 0 || !this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStack existing = this.getStackInSlot(slot);
        int limit = stack.m_41741_();
        if (!existing.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (existing.m_41619_()) {
                this.innerHandler.m_6836_(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
            }
            this.innerHandler.m_6596_();
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || slot != 1) {
            return ItemStack.f_41583_;
        }
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.m_41619_() || amount < existing.m_41613_()) {
            return ItemStack.f_41583_;
        }
        if (!simulate) {
            this.innerHandler.getResultContainer().m_6836_(0, ItemStack.f_41583_);
            this.innerHandler.m_8020_(0).m_41764_(this.innerHandler.m_8020_(0).m_41613_() - 1);
            this.innerHandler.m_6596_();
            return existing;
        }
        return existing.m_41777_();
    }

    public int getSlotLimit(int slot) {
        return this.getStackInSlot(slot).m_41741_();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }
}

