/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelCellVoxelShape;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PanelTileRenderer;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.properties.ComparatorMode;

public class Comparator
implements IPanelCell,
IPanelCellInfoProvider {
    private Integer input1 = 0;
    private Integer input2 = 0;
    private Integer output = 0;
    private Boolean subtract = false;
    private Boolean comparatorOverride = false;
    private Integer comparatorInput = 0;
    protected int changePending = -1;
    private int changedTick = -1;
    public static ResourceLocation TEXTURE_COMPARATOR_ON = new ResourceLocation("tinyredstone", "block/panel_comparator_on");
    public static ResourceLocation TEXTURE_COMPARATOR_OFF = new ResourceLocation("tinyredstone", "block/panel_comparator_off");
    public static ResourceLocation TEXTURE_COMPARATOR_SUBTRACT_ON = new ResourceLocation("tinyredstone", "block/panel_comparator_subtract_on");
    public static ResourceLocation TEXTURE_COMPARATOR_SUBTRACT_OFF = new ResourceLocation("tinyredstone", "block/panel_comparator_subtract_off");

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha) {
        VertexConsumer builder = buffer.m_6299_((double)alpha == 1.0 ? RenderType.m_110451_() : RenderType.m_110466_());
        TextureAtlasSprite sprite = RenderHelper.getSprite(PanelTileRenderer.TEXTURE);
        TextureAtlasSprite sprite_repeater = RenderHelper.getSprite(TEXTURE_COMPARATOR_OFF);
        if (this.output > 0 && this.subtract.booleanValue()) {
            sprite_repeater = RenderHelper.getSprite(TEXTURE_COMPARATOR_SUBTRACT_ON);
        } else if (this.output > 0) {
            sprite_repeater = RenderHelper.getSprite(TEXTURE_COMPARATOR_ON);
        } else if (this.subtract.booleanValue()) {
            sprite_repeater = RenderHelper.getSprite(TEXTURE_COMPARATOR_SUBTRACT_OFF);
        }
        matrixStack.m_85837_(0.0, 0.0, 0.25);
        this.add(builder, matrixStack, 0.0f, 0.0f, 0.0f, sprite_repeater.m_118409_(), sprite_repeater.m_118412_(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.0f, 0.0f, sprite_repeater.m_118410_(), sprite_repeater.m_118412_(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 1.0f, 0.0f, sprite_repeater.m_118410_(), sprite_repeater.m_118411_(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 0.0f, 1.0f, 0.0f, sprite_repeater.m_118409_(), sprite_repeater.m_118411_(), combinedLight, combinedOverlay, alpha);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStack.m_85837_(0.0, -0.25, 0.0);
        this.add(builder, matrixStack, 0.0f, 0.0f, 0.0f, sprite.m_118409_(), sprite.m_118412_(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.0f, 0.0f, sprite.m_118410_(), sprite.m_118412_(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.25f, 0.0f, sprite.m_118410_(), sprite.m_118411_(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 0.0f, 0.25f, 0.0f, sprite.m_118409_(), sprite.m_118411_(), combinedLight, combinedOverlay, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
        this.add(builder, matrixStack, 0.0f, 0.0f, 0.0f, sprite.m_118409_(), sprite.m_118412_(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.0f, 0.0f, sprite.m_118410_(), sprite.m_118412_(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.25f, 0.0f, sprite.m_118410_(), sprite.m_118411_(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 0.0f, 0.25f, 0.0f, sprite.m_118409_(), sprite.m_118411_(), combinedLight, combinedOverlay, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
        this.add(builder, matrixStack, 0.0f, 0.0f, 0.0f, sprite.m_118409_(), sprite.m_118412_(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.0f, 0.0f, sprite.m_118410_(), sprite.m_118412_(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.25f, 0.0f, sprite.m_118410_(), sprite.m_118411_(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 0.0f, 0.25f, 0.0f, sprite.m_118409_(), sprite.m_118411_(), combinedLight, combinedOverlay, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
        this.add(builder, matrixStack, 0.0f, 0.0f, 0.0f, sprite.m_118409_(), sprite.m_118412_(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.0f, 0.0f, sprite.m_118410_(), sprite.m_118412_(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.25f, 0.0f, sprite.m_118410_(), sprite.m_118411_(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 0.0f, 0.25f, 0.0f, sprite.m_118409_(), sprite.m_118411_(), combinedLight, combinedOverlay, alpha);
    }

    private void add(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float u, float v, int combinedLightIn, int combinedOverlayIn, float alpha) {
        renderer.m_252986_(stack.m_85850_().m_252922_(), x, y, z).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u, v).m_85969_(combinedLightIn).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        this.changedTick = cellPos.getPanelTile().getRelTickTime();
        return false;
    }

    private void checkInputs(PanelCellPos cellPos) {
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        PanelCellNeighbor leftNeighbor = cellPos.getNeighbor(Side.LEFT);
        PanelCellNeighbor rightNeighbor = cellPos.getNeighbor(Side.RIGHT);
        boolean co = backNeighbor != null && backNeighbor.hasComparatorOverride();
        int i1 = backNeighbor == null ? 0 : Math.max(backNeighbor.getStrongRsOutput(), backNeighbor.getWeakRsOutput());
        int i2 = Math.max(leftNeighbor == null ? 0 : leftNeighbor.getStrongRsOutput(), rightNeighbor == null ? 0 : rightNeighbor.getStrongRsOutput());
        if (i1 != this.input1 || i2 != this.input2 || co != this.comparatorOverride) {
            this.input1 = i1;
            this.input2 = i2;
            this.comparatorOverride = co;
            this.changePending = 1;
        }
    }

    private boolean updateOutput() {
        Integer input;
        Integer output1 = 0;
        Integer n = input = this.comparatorOverride != false ? this.comparatorInput : this.input1;
        output1 = this.subtract != false ? Integer.valueOf(Math.max(0, input - this.input2)) : Integer.valueOf(input >= this.input2 ? input : 0);
        if (output1 == this.output) {
            return false;
        }
        this.output = output1;
        return true;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        return this.getStrongRsOutput(outputDirection);
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        if (outputDirection == Side.FRONT && this.output > 0) {
            return this.output;
        }
        return 0;
    }

    @Override
    public boolean needsSolidBase() {
        return true;
    }

    @Override
    public boolean canAttachToBaseOnSide(Side side) {
        return side == Side.BOTTOM;
    }

    @Override
    public Side getBaseSide() {
        return Side.BOTTOM;
    }

    @Override
    public boolean tick(PanelCellPos cellPos) {
        if (this.changedTick > -1 && this.changedTick < cellPos.getPanelTile().getRelTickTime()) {
            this.checkInputs(cellPos);
            this.changedTick = -1;
        }
        boolean changed = false;
        if (!cellPos.getPanelTile().m_58904_().f_46443_) {
            PanelCellNeighbor backNeighbor;
            int cInput;
            if (this.comparatorOverride.booleanValue() && (cInput = (backNeighbor = cellPos.getNeighbor(Side.BACK)).getComparatorOverride()) != this.comparatorInput) {
                this.comparatorInput = cInput;
                this.changePending = 1;
            }
            if (this.changePending > 0) {
                --this.changePending;
            } else if (this.changePending == 0) {
                --this.changePending;
                changed = this.updateOutput();
            }
        }
        if (this.changedTick > -1) {
            this.checkInputs(cellPos);
            this.changedTick = -1;
        }
        return changed;
    }

    @Override
    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, Player player) {
        this.subtract = this.subtract == false;
        return this.updateOutput();
    }

    @Override
    public boolean hasActivation() {
        return true;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("output", this.output.intValue());
        nbt.m_128405_("input1", this.input1.intValue());
        nbt.m_128405_("input2", this.input2.intValue());
        nbt.m_128405_("changePending", this.changePending);
        nbt.m_128405_("comparatorInput", this.comparatorInput.intValue());
        nbt.m_128379_("subtract", this.subtract.booleanValue());
        nbt.m_128379_("comparatorOverride", this.comparatorOverride.booleanValue());
        nbt.m_128405_("changedTick", this.changedTick);
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag compoundNBT) {
        this.output = compoundNBT.m_128451_("output");
        this.input1 = compoundNBT.m_128451_("input1");
        this.input2 = compoundNBT.m_128451_("input2");
        this.changePending = compoundNBT.m_128451_("changePending");
        this.comparatorInput = compoundNBT.m_128451_("comparatorInput");
        this.subtract = compoundNBT.m_128471_("subtract");
        this.comparatorOverride = compoundNBT.m_128471_("comparatorOverride");
        this.changedTick = compoundNBT.m_128451_("changedTick");
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell pos) {
        overlayBlockInfo.addText("Mode", this.subtract != false ? ComparatorMode.SUBTRACT.toString() : ComparatorMode.COMPARE.toString());
    }

    @Override
    public PanelCellVoxelShape getShape() {
        return PanelCellVoxelShape.QUARTERCELLSLAB;
    }
}

