/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.registry;

import com.klikli_dev.theurgy.content.item.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.registry.CreativeModeTabRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.util.LevelUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SulfurRegistry {
    public static final DeferredRegister<Item> SULFURS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"theurgy");
    public static final RegistryObject<AlchemicalSulfurItem> GENERIC = SulfurRegistry.registerWithTagSourceNameOverride("generic");
    public static final RegistryObject<AlchemicalSulfurItem> LOGS = SulfurRegistry.registerWithTagSourceNameOverride("logs");
    public static final RegistryObject<AlchemicalSulfurItem> WHEAT = SulfurRegistry.registerDefault("wheat");
    public static final RegistryObject<AlchemicalSulfurItem> IRON = SulfurRegistry.registerWithSourceNameOverride("iron");
    public static final RegistryObject<AlchemicalSulfurItem> COPPER = SulfurRegistry.registerWithSourceNameOverride("copper");
    public static final RegistryObject<AlchemicalSulfurItem> SILVER = SulfurRegistry.registerWithSourceNameOverride("silver");
    public static final RegistryObject<AlchemicalSulfurItem> GOLD = SulfurRegistry.registerWithSourceNameOverride("gold");
    public static final RegistryObject<AlchemicalSulfurItem> NETHERITE = SulfurRegistry.registerWithSourceNameOverride("netherite");
    public static final RegistryObject<AlchemicalSulfurItem> URANIUM = SulfurRegistry.registerWithSourceNameOverride("uranium");
    public static final RegistryObject<AlchemicalSulfurItem> AZURE_SILVER = SulfurRegistry.registerWithSourceNameOverride("azure_silver");
    public static final RegistryObject<AlchemicalSulfurItem> ZINC = SulfurRegistry.registerWithSourceNameOverride("zinc");
    public static final RegistryObject<AlchemicalSulfurItem> OSMIUM = SulfurRegistry.registerWithSourceNameOverride("osmium");
    public static final RegistryObject<AlchemicalSulfurItem> NICKEL = SulfurRegistry.registerWithSourceNameOverride("nickel");
    public static final RegistryObject<AlchemicalSulfurItem> LEAD = SulfurRegistry.registerWithSourceNameOverride("lead");
    public static final RegistryObject<AlchemicalSulfurItem> ALLTHEMODIUM = SulfurRegistry.registerWithSourceNameOverride("allthemodium");
    public static final RegistryObject<AlchemicalSulfurItem> UNOBTAINIUM = SulfurRegistry.registerWithSourceNameOverride("unobtainium");
    public static final RegistryObject<AlchemicalSulfurItem> IRIDIUM = SulfurRegistry.registerWithSourceNameOverride("iridium");
    public static final RegistryObject<AlchemicalSulfurItem> TIN = SulfurRegistry.registerWithSourceNameOverride("tin");
    public static final RegistryObject<AlchemicalSulfurItem> CINNABAR = SulfurRegistry.registerWithSourceNameOverride("cinnabar");
    public static final RegistryObject<AlchemicalSulfurItem> CRIMSON_IRON = SulfurRegistry.registerWithSourceNameOverride("crimson_iron");
    public static final RegistryObject<AlchemicalSulfurItem> PLATINUM = SulfurRegistry.registerWithSourceNameOverride("platinum");
    public static final RegistryObject<AlchemicalSulfurItem> VIBRANIUM = SulfurRegistry.registerWithSourceNameOverride("vibranium");
    public static final RegistryObject<AlchemicalSulfurItem> DIAMOND = SulfurRegistry.registerWithSourceNameOverride("diamond");
    public static final RegistryObject<AlchemicalSulfurItem> EMERALD = SulfurRegistry.registerWithSourceNameOverride("emerald");
    public static final RegistryObject<AlchemicalSulfurItem> LAPIS = SulfurRegistry.registerWithSourceNameOverride("lapis");
    public static final RegistryObject<AlchemicalSulfurItem> QUARTZ = SulfurRegistry.registerWithSourceNameOverride("quartz");
    public static final RegistryObject<AlchemicalSulfurItem> AMETHYST = SulfurRegistry.registerWithSourceNameOverride("amethyst");
    public static final RegistryObject<AlchemicalSulfurItem> PRISMARINE = SulfurRegistry.registerWithSourceNameOverride("prismarine");
    public static final RegistryObject<AlchemicalSulfurItem> RUBY = SulfurRegistry.registerWithSourceNameOverride("ruby");
    public static final RegistryObject<AlchemicalSulfurItem> APATITE = SulfurRegistry.registerWithSourceNameOverride("apatite");
    public static final RegistryObject<AlchemicalSulfurItem> PERIDOT = SulfurRegistry.registerWithSourceNameOverride("peridot");
    public static final RegistryObject<AlchemicalSulfurItem> FLUORITE = SulfurRegistry.registerWithSourceNameOverride("fluorite");
    public static final RegistryObject<AlchemicalSulfurItem> SAPPHIRE = SulfurRegistry.registerWithSourceNameOverride("sapphire");
    public static final RegistryObject<AlchemicalSulfurItem> SAL_AMMONIAC = SulfurRegistry.registerWithSourceNameOverride("sal_ammoniac");
    public static final RegistryObject<AlchemicalSulfurItem> REDSTONE = SulfurRegistry.registerWithSourceNameOverride("redstone");
    public static final RegistryObject<AlchemicalSulfurItem> COAL = SulfurRegistry.registerDefault("coal");
    public static final RegistryObject<AlchemicalSulfurItem> SULFUR = SulfurRegistry.registerWithSourceNameOverride("sulfur");

    public static RegistryObject<AlchemicalSulfurItem> registerWithTagSourceNameOverride(String name) {
        return SulfurRegistry.register(name, () -> new AlchemicalSulfurItem(new Item.Properties()).overrideTagSourceName(true));
    }

    public static RegistryObject<AlchemicalSulfurItem> registerWithSourceNameOverride(String name) {
        return SulfurRegistry.register(name, () -> new AlchemicalSulfurItem(new Item.Properties()).overrideSourceName(true));
    }

    public static RegistryObject<AlchemicalSulfurItem> registerDefault(String name) {
        return SulfurRegistry.register(name, () -> new AlchemicalSulfurItem(new Item.Properties()));
    }

    public static <T extends Item> RegistryObject<T> register(String name, Supplier<T> sup) {
        return SULFURS.register("alchemical_sulfur_" + name, sup);
    }

    public static void onBuildCreativeModTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == CreativeModeTabRegistry.THEURGY.get()) {
            Level level = LevelUtil.getLevelWithoutContext();
            if (level == null) {
                return;
            }
            RecipeManager recipeManager = level.m_7465_();
            List liquefactionRecipes = recipeManager.m_44013_((RecipeType)RecipeTypeRegistry.LIQUEFACTION.get());
            SULFURS.getEntries().stream().map(RegistryObject::get).map(AlchemicalSulfurItem.class::cast).forEach(sulfur -> liquefactionRecipes.stream().filter(recipe -> recipe.m_8043_(level.m_9598_()) != null && recipe.m_8043_(level.m_9598_()).m_41720_() == sulfur).forEach(recipe -> event.m_246342_(recipe.m_8043_(level.m_9598_()).m_255036_(1))));
        }
    }
}

