/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.modonomicon.page.incubation;

import com.klikli_dev.modonomicon.book.page.BookRecipePage;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.render.page.BookRecipePageRenderer;
import com.klikli_dev.theurgy.content.gui.GuiTextures;
import com.klikli_dev.theurgy.content.recipe.IncubationRecipe;
import com.klikli_dev.theurgy.content.recipe.LiquefactionRecipe;
import com.klikli_dev.theurgy.integration.modonomicon.page.incubation.BookIncubationRecipePage;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class BookIncubationRecipePageRenderer
extends BookRecipePageRenderer<IncubationRecipe, BookIncubationRecipePage> {
    protected Map<IncubationRecipe, ItemStack[]> renderableSulfurIngredients = new HashMap<IncubationRecipe, ItemStack[]>();

    public BookIncubationRecipePageRenderer(BookIncubationRecipePage page) {
        super((BookRecipePage)page);
    }

    protected int getRecipeHeight() {
        return 65;
    }

    public void onBeginDisplayPage(BookContentScreen parentScreen, int left, int top) {
        super.onBeginDisplayPage(parentScreen, left, top);
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        List<LiquefactionRecipe> liquefactionRecipes = recipeManager.m_44013_((RecipeType)RecipeTypeRegistry.LIQUEFACTION.get()).stream().filter(r -> r.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()) != null).collect(Collectors.toList());
        if (((BookIncubationRecipePage)this.page).getRecipe1() != null) {
            this.renderableSulfurIngredients.put((IncubationRecipe)((BookIncubationRecipePage)this.page).getRecipe1(), this.getRenderableSulfurIngredients(liquefactionRecipes, (IncubationRecipe)((BookIncubationRecipePage)this.page).getRecipe1()));
        }
        if (((BookIncubationRecipePage)this.page).getRecipe2() != null) {
            this.renderableSulfurIngredients.put((IncubationRecipe)((BookIncubationRecipePage)this.page).getRecipe2(), this.getRenderableSulfurIngredients(liquefactionRecipes, (IncubationRecipe)((BookIncubationRecipePage)this.page).getRecipe2()));
        }
    }

    protected ItemStack[] getRenderableSulfurIngredients(List<LiquefactionRecipe> liquefactionRecipes, IncubationRecipe recipe) {
        return (ItemStack[])Arrays.stream(recipe.getSulfur().m_43908_()).map(sulfur -> {
            if (sulfur.m_41782_()) {
                return sulfur;
            }
            Item sulfurItem = sulfur.m_41720_();
            Optional<ItemStack> sulfurWithNbt = liquefactionRecipes.stream().filter(r -> r.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()).m_41720_() == sulfurItem).map(r -> r.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_())).findFirst();
            if (sulfurWithNbt.isPresent()) {
                sulfur = sulfur.m_41777_();
                sulfur.m_41751_(sulfurWithNbt.get().m_41783_());
            }
            return sulfur;
        }).toArray(ItemStack[]::new);
    }

    protected void drawRecipe(GuiGraphics guiGraphics, IncubationRecipe recipe, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
        recipeY += 10;
        if (!second) {
            if (!((BookIncubationRecipePage)this.page).getTitle1().isEmpty()) {
                this.renderTitle(guiGraphics, ((BookIncubationRecipePage)this.page).getTitle1(), false, 62, 0);
            }
        } else if (!((BookIncubationRecipePage)this.page).getTitle2().isEmpty()) {
            this.renderTitle(guiGraphics, ((BookIncubationRecipePage)this.page).getTitle2(), false, 62, recipeY - (((BookIncubationRecipePage)this.page).getTitle2().getString().isEmpty() ? 10 : 0) - 10);
        }
        GuiTextures.MODONOMICON_SLOT.render(guiGraphics, recipeX, recipeY);
        this.parentScreen.renderIngredient(guiGraphics, recipeX + 3, recipeY + 3, mouseX, mouseY, recipe.getMercury());
        GuiTextures.MODONOMICON_SLOT.render(guiGraphics, recipeX + 24, recipeY);
        this.parentScreen.renderIngredient(guiGraphics, recipeX + 24 + 3, recipeY + 3, mouseX, mouseY, recipe.getSalt());
        GuiTextures.MODONOMICON_SLOT.render(guiGraphics, recipeX, recipeY + 24);
        ItemStack[] sulfurs = this.renderableSulfurIngredients.get(recipe);
        if (sulfurs != null && sulfurs.length > 0) {
            this.parentScreen.renderItemStacks(guiGraphics, recipeX + 3, recipeY + 24 + 3, mouseX, mouseY, List.of(sulfurs));
        }
        GuiTextures.MODONOMICON_SLOT.render(guiGraphics, recipeX + 61 + 14, recipeY);
        this.parentScreen.renderItemStack(guiGraphics, recipeX + 61 + 3 + 14, recipeY + 3, mouseX, mouseY, recipe.m_8043_(this.parentScreen.getMinecraft().f_91073_.m_9598_()));
        GuiTextures.MODONOMICON_ARROW_RIGHT.render(guiGraphics, recipeX + 40 + 16, recipeY + 7);
        this.parentScreen.renderItemStack(guiGraphics, recipeX + 36 + 16, recipeY + 24, mouseX, mouseY, recipe.m_8042_());
    }
}

