/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.jei;

import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.content.item.DivinationRodItem;
import com.klikli_dev.theurgy.integration.jei.AlchemicalSulfurSubtypeInterpreter;
import com.klikli_dev.theurgy.integration.jei.DivinationRodSubtypeInterpreter;
import com.klikli_dev.theurgy.integration.jei.JeiRecipeTypes;
import com.klikli_dev.theurgy.integration.jei.recipes.AccumulationCategory;
import com.klikli_dev.theurgy.integration.jei.recipes.CalcinationCategory;
import com.klikli_dev.theurgy.integration.jei.recipes.DistillationCategory;
import com.klikli_dev.theurgy.integration.jei.recipes.IncubationCategory;
import com.klikli_dev.theurgy.integration.jei.recipes.LiquefactionCategory;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return Theurgy.loc("jei_plugin");
    }

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registration) {
        ItemRegistry.ITEMS.getEntries().stream().filter(item -> item.get() instanceof DivinationRodItem).forEach(item -> {
            registration.registerSubtypeInterpreter((Item)item.get(), (IIngredientSubtypeInterpreter)DivinationRodSubtypeInterpreter.get());
            Theurgy.LOGGER.debug("Registered Divination Rod JEI Subtype Interpreter for: {}", (Object)item.getKey());
        });
        SulfurRegistry.SULFURS.getEntries().stream().forEach(sulfur -> registration.registerSubtypeInterpreter((Item)sulfur.get(), (IIngredientSubtypeInterpreter)AlchemicalSulfurSubtypeInterpreter.get()));
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CalcinationCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new LiquefactionCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new DistillationCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new IncubationCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AccumulationCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        RecipeManager recipeManager = level.m_7465_();
        List calcinationRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.CALCINATION.get());
        registration.addRecipes(JeiRecipeTypes.CALCINATION, calcinationRecipes);
        List liquefactionRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.LIQUEFACTION.get());
        registration.addRecipes(JeiRecipeTypes.LIQUEFACTION, liquefactionRecipes);
        List distillationRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.DISTILLATION.get());
        registration.addRecipes(JeiRecipeTypes.DISTILLATION, distillationRecipes);
        List incubationRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.INCUBATION.get());
        registration.addRecipes(JeiRecipeTypes.INCUBATION, incubationRecipes);
        List accumulationRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.ACCUMULATION.get());
        registration.addRecipes(JeiRecipeTypes.ACCUMULATION, accumulationRecipes);
        List<ItemStack> sulfursWithoutRecipe = SulfurRegistry.SULFURS.getEntries().stream().map(RegistryObject::get).map(AlchemicalSulfurItem.class::cast).filter(sulfur -> liquefactionRecipes.stream().noneMatch(r -> r.m_8043_(level.m_9598_()) != null && r.m_8043_(level.m_9598_()).m_41720_() == sulfur)).map(ItemStack::new).toList();
        registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, sulfursWithoutRecipe);
        this.registerIngredientInfo(registration, (ItemLike)ItemRegistry.SAL_AMMONIAC_CRYSTAL.get());
    }

    public void registerIngredientInfo(IRecipeRegistration registration, ItemLike ingredient) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ingredient.m_5456_()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)("jei.theurgy.ingredient." + ForgeRegistries.ITEMS.getKey((Object)ingredient.m_5456_()).m_135815_() + ".description"))});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.CALCINATION_OVEN.get()), new RecipeType[]{JeiRecipeTypes.CALCINATION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.LIQUEFACTION_CAULDRON.get()), new RecipeType[]{JeiRecipeTypes.LIQUEFACTION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.DISTILLER.get()), new RecipeType[]{JeiRecipeTypes.DISTILLATION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.INCUBATOR.get()), new RecipeType[]{JeiRecipeTypes.INCUBATION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.SAL_AMMONIAC_ACCUMULATOR.get()), new RecipeType[]{JeiRecipeTypes.ACCUMULATION});
    }
}

