/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.loot;

import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class TheurgyBlockLootSubProvider
extends BlockLootSubProvider {
    public TheurgyBlockLootSubProvider() {
        super(Set.of(), FeatureFlags.f_244280_.m_247355_());
    }

    public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
        this.m_245660_();
        this.f_244441_.forEach(consumer::accept);
    }

    protected void m_245660_() {
        this.m_245724_((Block)BlockRegistry.PYROMANTIC_BRAZIER.get());
        this.dropDoubleBlockOnce((Block)BlockRegistry.CALCINATION_OVEN.get());
        this.dropDoubleBlockOnce((Block)BlockRegistry.LIQUEFACTION_CAULDRON.get());
        this.dropDoubleBlockOnce((Block)BlockRegistry.DISTILLER.get());
        this.dropDoubleBlockOnce((Block)BlockRegistry.INCUBATOR.get());
        this.m_245724_((Block)BlockRegistry.INCUBATOR_MERCURY_VESSEL.get());
        this.m_245724_((Block)BlockRegistry.INCUBATOR_SULFUR_VESSEL.get());
        this.m_245724_((Block)BlockRegistry.INCUBATOR_SALT_VESSEL.get());
        this.m_245724_((Block)BlockRegistry.SAL_AMMONIAC_ACCUMULATOR.get());
        this.m_245724_((Block)BlockRegistry.SAL_AMMONIAC_TANK.get());
        this.dropSelfWithNbt((Block)BlockRegistry.MERCURY_CATALYST.get(), "mercuryFluxStorage", "mercuryFluxToConvert", "currentMercuryFluxPerTick", "inventory");
        this.dropSelfWithNbt((Block)BlockRegistry.CALORIC_FLUX_EMITTER.get(), "mercuryFluxStorage");
        this.m_246481_((Block)BlockRegistry.SAL_AMMONIAC_ORE.get(), block -> this.m_246109_((Block)block, (Item)ItemRegistry.SAL_AMMONIAC_CRYSTAL.get()));
        this.m_246481_((Block)BlockRegistry.DEEPSLATE_SAL_AMMONIAC_ORE.get(), block -> this.m_246109_((Block)block, (Item)ItemRegistry.SAL_AMMONIAC_CRYSTAL.get()));
    }

    protected void dropDoubleBlockOnce(Block pBlock) {
        this.m_247577_(pBlock, this.m_245178_(pBlock, (Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected final void dropSelfWithNbt(Block pBlock, String ... sourcePaths) {
        this.dropSelfWithNbt(pBlock, (Pair[])Arrays.stream(sourcePaths).map(s -> Pair.of((Object)s, (Object)("BlockEntityTag." + s))).toArray(Pair[]::new));
    }

    @SafeVarargs
    protected final void dropSelfWithNbt(Block pBlock, Pair<String, String> ... sourceTargetPathPairs) {
        this.m_247577_(pBlock, this.createSelfWithNbtDrop(pBlock, this.copyData(sourceTargetPathPairs)));
    }

    protected void dropSelfWithNbt(Block pBlock, CopyNbtFunction.Builder data) {
        this.m_247577_(pBlock, this.createSelfWithNbtDrop(pBlock, data));
    }

    protected LootTable.Builder createSelfWithNbtDrop(Block pBlock, CopyNbtFunction.Builder data) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_247733_((ItemLike)pBlock, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)pBlock).m_79078_((LootItemFunction.Builder)data))));
    }

    protected CopyNbtFunction.Builder copyData(Pair<String, String> ... sourceTargetPathPairs) {
        CopyNbtFunction.Builder builder = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_);
        for (Pair<String, String> pair : sourceTargetPathPairs) {
            builder.m_80279_((String)pair.getFirst(), (String)pair.getSecond());
        }
        return builder;
    }
}

