/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryEntryMap;
import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.datagen.book.EntryBackground;
import com.klikli_dev.theurgy.datagen.book.TheurgyBookProvider;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.SaltRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class OreRefiningEntryProvider
extends CategoryProvider {
    public OreRefiningEntryProvider(TheurgyBookProvider parent, CategoryEntryMap entryMap) {
        super((BookProvider)parent, "dummy");
        this.entryMap = entryMap;
    }

    public TheurgyBookProvider parent() {
        return (TheurgyBookProvider)this.parent;
    }

    protected String[] generateEntryMap() {
        throw new UnsupportedOperationException("This is a dummy provider to help generate entries, it should not be used to generate a Category.");
    }

    protected void generateEntries() {
        throw new UnsupportedOperationException("This is a dummy provider to help generate entries, it should not be used to generate a Category.");
    }

    protected BookCategoryModel generateCategory() {
        throw new UnsupportedOperationException("This is a dummy provider to help generate entries, it should not be used to generate a Category.");
    }

    public BookEntryModel aboutOreRefiningEntry(char location) {
        this.context().entry("about_ore_refining");
        this.add(this.context().entryName(), "Ore Refining");
        this.add(this.context().entryDescription(), "Triple your ore yield - at a cost!");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151050_})).withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Ore Duplication");
        this.add(this.context().pageText(), "In the following pages and entries we will attempt to create three iron ingots out of just one iron ore using alchemical processes.\n");
        this.context().page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Spagyrics for Refining");
        this.add(this.context().pageText(), "The easiest application of Spagyrics is the refining of ores and raw metals. The process of smelting ores in a furnace is wasteful, as it only yields a single ingot per ore, losing a lot of the precious raw materials in the process. Alchemists can extract even the last iota of value from ores, but the process is somewhat more complex.\n");
        this.context().page("overview");
        BookTextPageModel overview = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "The Process");
        this.add(this.context().pageText(), "To refine an Ore or Raw Metal you first need to {0} it, which will yield multiple Ore Sulfur. Additionally you need to obtain multiple heaps of {1} to provide a body for this multiplied Sulfur, and some {2} to provide the mercury for the soul of the resulting refined ingots.\n", new Object[]{this.entryLink("liquefy", "spagyrics", "liquefaction_cauldron"), this.itemLink("Mineral Salt", (ItemLike)SaltRegistry.MINERAL.get()), this.itemLink("Mercury Shards", (ItemLike)ItemRegistry.MERCURY_SHARD.get())});
        this.context().page("cost");
        BookTextPageModel cost = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "The Cost");
        this.add(this.context().pageText(), "To bring it to a point, the cost of significantly increasing ore yield with Spagyrics is having to obtain high amounts of {0} which is mainly sourced from ... Metals.\n", new Object[]{this.itemLink("Mineral Salt", (ItemLike)SaltRegistry.MINERAL.get())});
        this.context().page("cost2");
        BookTextPageModel cost2 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "The Cost");
        this.add(this.context().pageText(), "The first and obvious solution to this chicken-and-egg problem is to {0} abundant metals, such as {1}, and use the salt to {2} more valuable materials such as {3} or even {4} as output.\n", new Object[]{this.entryLink("calcinate", "spagyrics", "calcination_oven"), this.itemLink((ItemLike)Items.f_151051_), this.entryLink("incubate", "spagyrics", "incubator"), this.itemLink((ItemLike)Items.f_42416_), this.itemLink((ItemLike)Items.f_42415_)});
        this.context().page("silver_lining");
        BookTextPageModel silverLining = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "The Silver Lining");
        this.add(this.context().pageText(), "As luck would have it another option to obtain {0} is to calcinate it from {1}, which is in turn obtained by calcinating Sand, Cobblestone, etc. This is a somewhat lossy process as it requires a lot of {1}, but it does have the upside of giving those abundant materials a use.\n", new Object[]{this.itemLink("Mineral Salt", (ItemLike)SaltRegistry.MINERAL.get()), this.itemLink("Strata Salt", (ItemLike)SaltRegistry.STRATA.get())});
        this.context().page("soul");
        BookTextPageModel soul = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "The Soul");
        this.add(this.context().pageText(), "Obtaining {0} is usually not much of an issue as a wide variety of materials can be {1} to obtain in.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.MERCURY_SHARD.get()), this.entryLink("distilled", "spagyrics", "distiller")});
        this.context().page("next");
        BookTextPageModel next = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Further Reading");
        this.add(this.context().pageText(), "The next entries will guide you through the process of obtaining all the materials and creating your iron ingots.\n");
        return this.entry(location).withIcon((ItemLike)Items.f_151050_).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{intro, intro2, overview, cost, cost2, silverLining, soul, next});
    }

    public BookEntryModel neededApparatusEntry(char location) {
        this.context().entry("needed_apparatus");
        this.add(this.context().entryName(), "Required Apparatus");
        this.add(this.context().entryDescription(), "Tools for Refinement");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Required Apparatus");
        this.add(this.context().pageText(), "Ore Refining needs all of the Spagyrics Apparatus to extract all the needed materials and recombine them.\nReview the full {0} Category on how to craft and use them.\n", new Object[]{this.categoryLink("Spagyrics", "spagyrics")});
        this.context().page("pyromantic_brazier");
        BookSpotlightPageModel pyromantic_brazier = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.PYROMANTIC_BRAZIER.get()})).withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "You will need 4 of these to power the other Apparatus.\n");
        this.context().page("calcination_oven");
        BookSpotlightPageModel calcination_oven = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CALCINATION_OVEN.get()})).withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "The Calcination Oven will allow you to create the {0}.\n", new Object[]{this.itemLink("Mineral Salt", (ItemLike)SaltRegistry.MINERAL.get())});
        this.context().page("sal_ammoniac_accumulator");
        BookSpotlightPageModel sal_ammoniac_accumulator = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.SAL_AMMONIAC_ACCUMULATOR.get()})).withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "The Sal Ammoniac Accumulator will fill the Sal Ammoniac Tank with solvent.\n");
        this.context().page("sal_ammoniac_tank");
        BookSpotlightPageModel sal_ammoniac_tank = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.SAL_AMMONIAC_TANK.get()})).withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "The Sal Ammoniac Tank stores the solvent - Sal Ammoniac - for use in the Liquefaction Cauldron.\n");
        this.context().page("liquefaction_cauldron");
        BookSpotlightPageModel liquefaction_cauldron = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LIQUEFACTION_CAULDRON.get()})).withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "The Liquefaction Cauldron uses Sal Ammoniac to extract Alchemical Sulfur.\n");
        this.context().page("distiller");
        BookSpotlightPageModel distiller = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.DISTILLER.get()})).withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "The Distiller creates {0}.\n", new Object[]{this.itemLink("Mercury Shards", (ItemLike)ItemRegistry.MERCURY_SHARD.get())});
        this.context().page("incubator");
        BookSpotlightPageModel incubator = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.INCUBATOR.get()})).withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "Finally, the incubator recombines the Salt, Sulfur, and Mercury into the refined item, Iron Ingots in our case.\nIt needs one each of {0}, {1}, {2} to hold the input materials.\n", new Object[]{this.itemLink("Salt Vessel", (ItemLike)ItemRegistry.INCUBATOR_SALT_VESSEL.get()), this.itemLink("Mercury Vessel", (ItemLike)ItemRegistry.INCUBATOR_MERCURY_VESSEL.get()), this.itemLink("Sulfur Vessel", (ItemLike)ItemRegistry.INCUBATOR_SULFUR_VESSEL.get())});
        this.context().page("next_steps");
        BookTextPageModel next_steps = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Next Steps");
        this.add(this.context().pageText(), "Place all the apparatus, those that need heating on pyromantic braziers. Prepare some Coal to heat the braziers, then open the next entry.\n");
        return this.entry(location).withIcon((ItemLike)ItemRegistry.DISTILLER.get()).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{intro, pyromantic_brazier, calcination_oven, sal_ammoniac_accumulator, sal_ammoniac_tank, liquefaction_cauldron, distiller, incubator, next_steps});
    }

    public BookEntryModel createSolventEntry(char location) {
        this.context().entry("create_solvent");
        this.add(this.context().entryName(), "Accumulating Solvent");
        this.add(this.context().entryDescription(), "Obtaining Sal Ammoniac - they key to Sulfur Extraction");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.SAL_AMMONIAC_BUCKET.get()})).withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "There are two ways of obtaining Sal Ammoniac, both use the Accumulator Apparatus. The first, slower, option is to simply place water in the accumulator, and let it slowly concentrate the inherently contained Sal Ammoniac. The second, faster, option is to additionally add a {0} to speed up the process significantly.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.SAL_AMMONIAC_CRYSTAL.get())});
        this.context().page("step1");
        BookTextPageModel step1 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Filling the Accumulator");
        this.add(this.context().pageText(), "After placing the {0} on a {1}, right-click the {0} with water buckets (up to 10) to fill it.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.SAL_AMMONIAC_ACCUMULATOR.get()), this.itemLink((ItemLike)ItemRegistry.SAL_AMMONIAC_TANK.get())});
        this.context().page("step2");
        BookTextPageModel step2 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Adding Crystals");
        this.add(this.context().pageText(), "Optionally you can now right-click the {0} with a {1} (obtained by mining). You will get Sal Ammoniac regardless, but the crystal will speed up the process significantly.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.SAL_AMMONIAC_ACCUMULATOR.get()), this.itemLink((ItemLike)ItemRegistry.SAL_AMMONIAC_CRYSTAL.get())});
        this.context().page("step3");
        BookTextPageModel step3 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Obtaining the Sal Ammoniac");
        this.add(this.context().pageText(), "Once the {0} has filled up sufficiently, you can right-click it with an empty bucket to obtain a {1}.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.SAL_AMMONIAC_TANK.get()), this.itemLink((ItemLike)ItemRegistry.SAL_AMMONIAC_BUCKET.get())});
        return this.entry(location, (ItemLike)ItemRegistry.SAL_AMMONIAC_BUCKET.get()).withPages(new BookPageModel[]{intro, step1, step2, step3});
    }

    public BookEntryModel createSulfurEntry(char location) {
        this.context().entry("create_sulfur");
        this.add(this.context().entryName(), "Extracting Sulfur");
        this.add(this.context().entryDescription(), "Obtaining Sulfur - the \"Soul\"");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)SulfurRegistry.IRON.get()})).withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "Sulfur extraction is the part of ore purification that leads to [#]($PURPLE)multiplication[#](). One Ore or Raw Metal yields multiple sulfurs, which then each can be refined into an ingot.\n");
        this.context().page("step1");
        BookTextPageModel step1 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Filling the Liquefaction Cauldron");
        this.add(this.context().pageText(), "Right-click the {0} with a {1} to fill it.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.LIQUEFACTION_CAULDRON.get()), this.itemLink((ItemLike)ItemRegistry.SAL_AMMONIAC_BUCKET.get())});
        this.context().page("step2");
        BookTextPageModel step2 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Adding Raw Materials");
        this.add(this.context().pageText(), "Now right-click the {0} with the item you want to extract sulfur from, such as {1}. The item will be placed inside.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.LIQUEFACTION_CAULDRON.get()), this.itemLink((ItemLike)Items.f_151050_)});
        this.context().page("step3");
        BookTextPageModel step3 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Providing Heat");
        this.add(this.context().pageText(), "Now add fuel, such as Coal, to the {0} below the {1} to heat it up.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.PYROMANTIC_BRAZIER.get()), this.itemLink((ItemLike)ItemRegistry.LIQUEFACTION_CAULDRON.get())});
        this.context().page("step4");
        BookTextPageModel step4 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Obtaining the Sulfur");
        this.add(this.context().pageText(), "After a while some sulfur will have been extracted, you can right-click the {0} with an empty hand to obtain {1}.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.LIQUEFACTION_CAULDRON.get()), this.itemLink("Alchemical Sulfur", (ItemLike)SulfurRegistry.IRON.get())});
        return this.entry(location, (ItemLike)SulfurRegistry.IRON.get()).withPages(new BookPageModel[]{intro, step1, step2, step3, step4});
    }

    public BookEntryModel createSaltEntry(char location) {
        this.context().entry("create_salt");
        this.add(this.context().entryName(), "Extracting Salt");
        this.add(this.context().entryDescription(), "Obtaining Salt - the \"Body\"");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)SaltRegistry.MINERAL.get()})).withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "Salt is needed in order to create items from Alchemical Sulfur. The type of salt needs to match the type of sulfur - for our project that involves {0} we need {1}, which covers all types of ores and metals.\n", new Object[]{this.itemLink("Iron Sulfur", (ItemLike)SulfurRegistry.IRON.get()), this.itemLink("Mineral Salt", (ItemLike)SaltRegistry.MINERAL.get())});
        this.context().page("step1");
        BookTextPageModel step1 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Calcinating Minerals");
        this.add(this.context().pageText(), "Right-click the {0} with any Mineral such as Ores, Raw Metals or Ingots to calcinate it.\nOne option is to use a Stack of {1}, which in turn is calcinated from Stone, Sand, Gravel, Dirt, etc.\nAnother great source is {2}, as it is renewable.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.CALCINATION_OVEN.get()), this.itemLink("Strata Salt", (ItemLike)SaltRegistry.STRATA.get()), this.itemLink((ItemLike)Items.f_42414_)});
        this.context().page("step2");
        BookTextPageModel step2 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Providing Heat");
        this.add(this.context().pageText(), "Now add fuel, such as Coal, to the {0} below the {1} to heat it up.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.PYROMANTIC_BRAZIER.get()), this.itemLink((ItemLike)ItemRegistry.CALCINATION_OVEN.get())});
        this.context().page("step3");
        BookTextPageModel step3 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Obtaining the Salt");
        this.add(this.context().pageText(), "After a while some salt will have been created, you can right-click the {0} with an empty hand to obtain {1}.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.CALCINATION_OVEN.get()), this.itemLink("Mineral Salt", (ItemLike)SaltRegistry.MINERAL.get())});
        return this.entry(location, (ItemLike)SaltRegistry.MINERAL.get()).withPages(new BookPageModel[]{intro, step1, step2, step3});
    }

    public BookEntryModel createMercuryEntry(char location) {
        this.context().entry("create_mercury");
        this.add(this.context().entryName(), "Extracting Mercury");
        this.add(this.context().entryDescription(), "Obtaining Mercury - the \"Spirit\"");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MERCURY_SHARD.get()})).withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "Mercury is the spirit, or energy, contained within matter. Like Salt, it is needed to create items from Alchemical Sulfur. Almost all items yield Mercury, but the more valuable and the more refined the item, the more mercury they will yield.\n");
        this.context().page("step1");
        BookTextPageModel step1 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Distilling Mercury");
        this.add(this.context().pageText(), "Right-click the {0} with any mercury-yielding item, such as Crops, Food, Ores, Raw Metals, but also Stone, Sand, Glass, ...\\\nFor low-value items you may need to add multiple items at once to obtain even one {1}.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.DISTILLER.get()), this.itemLink((ItemLike)ItemRegistry.MERCURY_SHARD.get())});
        this.context().page("step2");
        BookTextPageModel step2 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Providing Heat");
        this.add(this.context().pageText(), "Now add fuel, such as Coal, to the {0} below the {1} to heat it up.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.PYROMANTIC_BRAZIER.get()), this.itemLink((ItemLike)ItemRegistry.DISTILLER.get())});
        this.context().page("step3");
        BookTextPageModel step3 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Obtaining the Mercury");
        this.add(this.context().pageText(), "After a while some mercury shards will have been created, you can right-click the {0} with an empty hand to obtain {1}.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.DISTILLER.get()), this.itemLink((ItemLike)ItemRegistry.MERCURY_SHARD.get())});
        return this.entry(location, (ItemLike)ItemRegistry.MERCURY_SHARD.get()).withPages(new BookPageModel[]{intro, step1, step2, step3});
    }

    public BookEntryModel incubationEntry(char location) {
        this.context().entry("incubation");
        this.add(this.context().entryName(), "Incubating Iron");
        this.add(this.context().entryDescription(), "Creating Iron Ingots from Sulfur, Salt and Mercury");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Incubating Iron");
        this.add(this.context().pageText(), "The final step is to recombine the three principles into usable Iron Ingots.\n");
        this.context().page("step1");
        BookTextPageModel step1 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Filling the Vessels");
        this.add(this.context().pageText(), "Right-click the {0}, {1} and {2} with the Sulfur, Salt and Mercury you obtained earlier respectively to fill them.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.INCUBATOR_SULFUR_VESSEL.get()), this.itemLink((ItemLike)ItemRegistry.INCUBATOR_SALT_VESSEL.get()), this.itemLink((ItemLike)ItemRegistry.INCUBATOR_MERCURY_VESSEL.get())});
        this.context().page("step2");
        BookTextPageModel step2 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Providing Heat");
        this.add(this.context().pageText(), "Now add fuel, such as Coal, to the {0} below the {1} to heat it up.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.PYROMANTIC_BRAZIER.get()), this.itemLink((ItemLike)ItemRegistry.INCUBATOR.get())});
        this.context().page("step3");
        BookTextPageModel step3 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Obtaining the Incubated Item");
        this.add(this.context().pageText(), "After a while the input items will have been consumed and incubated into the result, you can right-click the {0} with an empty hand to obtain 3x {1}.\n\\\n\\\n**Congratulations, you created 2 Ingots from 1 Raw Metal!**\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.INCUBATOR.get()), this.itemLink((ItemLike)Items.f_42416_)});
        return this.entry(location, (ItemLike)Items.f_42416_).withPages(new BookPageModel[]{intro, step1, step2, step3});
    }
}

