/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.datagen.book.DivinationRodEntryProvider;
import com.klikli_dev.theurgy.datagen.book.EntryBackground;
import com.klikli_dev.theurgy.datagen.book.OreRefiningEntryProvider;
import com.klikli_dev.theurgy.datagen.book.TheurgyBookProvider;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GettingStartedCategoryProvider
extends CategoryProvider {
    public static final String CATEGORY_ID = "getting_started";

    public GettingStartedCategoryProvider(TheurgyBookProvider parent) {
        super((BookProvider)parent, CATEGORY_ID);
    }

    public TheurgyBookProvider parent() {
        return (TheurgyBookProvider)this.parent;
    }

    protected String[] generateEntryMap() {
        return new String[]{"__________________________________", "__________________\u1e0d___\u010f_\u1e11_\u1e13_______", "__________________________________", "________________d___\u1e0b_____________", "______________________\u0256_\u1d91_________", "__________________\u0111_______________", "__________________________________", "__________i_a___________\u0151_\u00f6_______", "__________________________________", "____________u_s_\u0161___o_\u00f3___\u00f4_\u00f5_____", "__________________________________", "______________m_\u1e3f_______\u00f2_________", "__________________________________"};
    }

    protected void generateEntries() {
        DivinationRodEntryProvider rods = new DivinationRodEntryProvider(this.parent(), this.entryMap());
        OreRefiningEntryProvider ore = new OreRefiningEntryProvider(this.parent(), this.entryMap());
        BookEntryModel introEntry = this.add(this.introEntry('i'));
        BookEntryModel aboutModEntry = this.add(this.aboutModEntry('a'));
        BookEntryModel aboutDivinationRods = this.add(rods.aboutDivinationRods('d'));
        BookEntryModel t1DivinationRod = this.add(rods.t1DivinationRodEntry('\u1e0d'));
        BookEntryModel abundantAndCommonSulfurAttunedDivinationRod = this.add(rods.abundantAndCommonSulfurAttunedDivinationRodEntry('\u0111'));
        BookEntryModel amethystDivinationRod = this.add(rods.amethystDivinationRodEntry('\u1e0b'));
        BookEntryModel t2DivinationRod = this.add(rods.t2DivinationRodEntry('\u010f'));
        BookEntryModel t3DivinationRod = this.add(rods.t3DivinationRodEntry('\u1e11'));
        BookEntryModel t4DivinationRod = this.add(rods.t4DivinationRodEntry('\u1e13'));
        BookEntryModel rareSulfurAttunedDivinationRod = this.add(rods.rareSulfurAttunedDivinationRodEntry('\u0256'));
        BookEntryModel preciousSulfurAttunedDivinationRod = this.add(rods.preciousSulfurAttunedDivinationRodEntry('\u1d91'));
        BookEntryModel spagyrics = this.add(this.spagyricsEntry('s'));
        BookEntryModel apparatusHowTo = this.add(this.apparatusHowToEntry('u'));
        BookEntryModel spagyricsLink = this.add(this.spagyricsLinkEntry('\u0161'));
        BookEntryModel aboutOreRefining = this.add(ore.aboutOreRefiningEntry('o'));
        BookEntryModel neededApparatus = this.add(ore.neededApparatusEntry('\u00f3'));
        BookEntryModel createSolvent = this.add(ore.createSolventEntry('\u0151'));
        BookEntryModel createSulfur = this.add(ore.createSulfurEntry('\u00f6'));
        BookEntryModel createSalt = this.add(ore.createSaltEntry('\u00f4'));
        BookEntryModel createMercury = this.add(ore.createMercuryEntry('\u00f2'));
        BookEntryModel incubation = this.add(ore.incubationEntry('\u00f5'));
        BookEntryModel mercuryFlux = this.add(this.mercuryFluxEntry('m'));
        BookEntryModel mercuryFluxLink = this.add(this.mercuryFluxLinkEntry('\u1e3f'));
        aboutModEntry.withParent(introEntry);
        aboutDivinationRods.withParent(aboutModEntry);
        t1DivinationRod.withParent(aboutDivinationRods);
        abundantAndCommonSulfurAttunedDivinationRod.withParent(aboutDivinationRods);
        abundantAndCommonSulfurAttunedDivinationRod.withParent(spagyricsLink);
        amethystDivinationRod.withParent(t1DivinationRod);
        amethystDivinationRod.withParent(abundantAndCommonSulfurAttunedDivinationRod);
        t2DivinationRod.withParent(amethystDivinationRod);
        t3DivinationRod.withParent(t2DivinationRod);
        t4DivinationRod.withParent(t3DivinationRod);
        rareSulfurAttunedDivinationRod.withParent(amethystDivinationRod);
        preciousSulfurAttunedDivinationRod.withParent(rareSulfurAttunedDivinationRod);
        spagyrics.withParent(aboutModEntry);
        apparatusHowTo.withParent(spagyrics);
        spagyricsLink.withParent(spagyrics);
        aboutOreRefining.withParent(spagyricsLink);
        neededApparatus.withParent(aboutOreRefining);
        createSolvent.withParent(neededApparatus);
        createSulfur.withParent(createSolvent);
        createSalt.withParent(neededApparatus);
        createMercury.withParent(neededApparatus);
        incubation.withParent(createMercury).withParent(createSalt).withParent(createSulfur);
        mercuryFlux.withParent(spagyrics);
        mercuryFluxLink.withParent(mercuryFlux);
    }

    protected BookCategoryModel generateCategory() {
        this.add(this.context().categoryName(), "Getting Started");
        return BookCategoryModel.create((ResourceLocation)Theurgy.loc(this.context().categoryId()), (String)this.context().categoryName()).withIcon((ItemLike)ItemRegistry.THE_HERMETICA_ICON.get()).withBackground(Theurgy.loc("textures/gui/book/bg_nightsky.png"));
    }

    private BookEntryModel introEntry(char location) {
        this.context().entry("intro");
        this.add(this.context().entryName(), "About this Work");
        this.add(this.context().entryDescription(), "About using The Hermetica");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "About this Work");
        this.add(this.context().pageText(), "The following pages will lead the novice alchemist on their journey through the noble art of the transformation of matter and mind. This humble author will share their experiences, thoughts and research notes to guide the valued reader in as safe a manner as the subject matter allows.\n");
        this.context().page("help");
        BookTextPageModel help = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Seeking Counsel");
        this.add(this.context().pageText(), "If the reader finds themselves in trouble of any kind, prompt assistance will be provided at the Council of Alchemists, known also as Kli Kli's Discord Server.\n\\\n\\\n[To get help, join us at https://invite.gg/klikli](https://invite.gg/klikli)\n");
        return this.entry(location).withIcon((ItemLike)ItemRegistry.THE_HERMETICA_ICON.get()).withEntryBackground(EntryBackground.CATEGORY_START).withPages(new BookPageModel[]{intro, help});
    }

    private BookEntryModel aboutModEntry(char location) {
        this.context().entry("about_mod");
        this.add(this.context().entryName(), "The Art of Alchemy");
        this.add(this.context().entryDescription(), "About this Mod");
        this.context().page("about");
        BookTextPageModel about = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "The Art of Alchemy");
        this.add(this.context().pageText(), "Welcome, dear reader, to Theurgy, a mod that explores the ancient and revered art of classical alchemy. As you embark on your journey through the noble art of transformation, you will be equipped with divination rods to make finding resources in the world easier.\n");
        this.context().page("about2");
        BookTextPageModel about2 = BookTextPageModel.builder().withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "Through diligent study and practice, you will then learn to use alchemical devices to refine, replicate, and transform resources into new and useful materials. Along the way, you will have the opportunity to craft alchemical devices and equipment to aid you in your endeavors.\n");
        this.context().page("about3");
        BookTextPageModel about3 = BookTextPageModel.builder().withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "As a final note, alchemists are guided by reason and logic, not superstition or magic. Our experiments are based on careful observation, meticulous record-keeping, and rigorous testing. We do not claim to possess supernatural powers, but rather seek to harness the natural forces of the world around us to achieve our goals.\n");
        this.context().page("features");
        BookTextPageModel features = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Features");
        this.add(this.context().pageText(), "- Divination rods to find ores\n- Ore refining (= more ingots per ore/raw metal)\n- Future: Item replication (create duplicates of items you have)\n- Future: Item transformation (create new items from other items)\n");
        this.context().page("features2");
        BookTextPageModel features2 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "More Features");
        this.add(this.context().pageText(), "- Future: Item Transportation\n- Future: Weapons and Equipment\n- Future: Devices to assist in common tasks\n");
        return this.entry(location).withIcon((ItemLike)Items.f_42686_).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{about, about2, about3, features, features2});
    }

    private BookEntryModel apparatusHowToEntry(char location) {
        this.context().entry("apparatus_how_to");
        this.add(this.context().entryName(), "Alchemical Apparatus");
        this.add(this.context().entryDescription(), "How to interact with the tools of the trade");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Alchemical Apparatus");
        this.add(this.context().pageText(), "Alchemist use a variety of tools and devices to aid them in their work. These devices are collectively referred to as apparatus.\n\\\n\\\nIt is important to understand that each apparatus should only have one specific function, such as generating heat or melting items.\n");
        this.context().page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.builder().withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "By adhering to this principle, we can create a modular system that allows for greater flexibility and efficiency in our work.\n\\\n\\\nFurther, all apparatus follow a standardized interaction pattern that makes it easier to use them both for manual interactions and for automation.\n");
        this.context().page("manual_interaction");
        BookTextPageModel manualInteraction = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Manual Interaction");
        this.add(this.context().pageText(), "To interact with an apparatus, approach it and right-click on it.\n\\\n\\\n**Taking Output Items**\\\nIf you have an empty hand, the machine will first try to take the contents of its output slot and place them in your inventory.\n");
        this.context().page("manual_interaction2");
        BookTextPageModel manualInteraction2 = BookTextPageModel.builder().withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "**Taking Input Items**\\\nIf there are no output items, it will instead try to place the contents of its input slot into your inventory, effectively emptying it.\n\\\n\\\n**Inserting Items**\\\nIf you have an item in your hand, the apparatus will automatically try to insert it into the input slot.\n");
        this.context().page("fluid_interaction");
        BookTextPageModel fluidInteraction = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Fluids");
        this.add(this.context().pageText(), "If you click on an apparatus with a filled fluid container in your hand, it will try to empty the container into the device.\n\\\n\\\nIf you click on an apparatus with an empty fluid container in your hand, it will instead try to fill the container from the device.\n");
        this.context().page("emptying_fluids");
        BookTextPageModel emptyingFluids = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Emptying Fluids");
        this.add(this.context().pageText(), "Crouch and Right-Click on an apparatus to empty all fluids from it.\n\\\n\\\nThis is particularly useful if small amounts of fluid are left but you want to add a full bucket\n");
        this.context().page("automatic_interaction");
        BookTextPageModel automaticInteraction = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Automatic Interaction");
        this.add(this.context().pageText(), "Automatic interactions also use a standardized pattern.\n\\\n\\\n**Input** slots can be accessed from the **top**, while **output** slots are available at the **bottom**.\\\n\\\nA **combined inventory** can be found at the horizontal **sides**.\n");
        return this.entry(location).withIcon((ItemLike)BlockRegistry.PYROMANTIC_BRAZIER.get()).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{intro, intro2, manualInteraction, manualInteraction2, fluidInteraction, emptyingFluids, automaticInteraction});
    }

    private BookEntryModel spagyricsEntry(char location) {
        this.context().entry("spagyrics");
        this.add(this.context().entryName(), "Spagyrics");
        this.add(this.context().entryDescription(), "Mastery over Matter");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Spagyrics");
        this.add(this.context().pageText(), "While divination rods are a useful tool to obtain *more* materials, they rely on the natural abundance of such materials.\n\\\n\\\nSpagyrics pursue the goal of *creating* materials out of other, possibly more abundant, materials.");
        this.context().page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Learn More");
        this.add(this.context().pageText(), "Open the {0} to learn more about the various required alchemical processes.\n", new Object[]{this.categoryLink("Spagyrics Category", "spagyrics")});
        return this.entry(location).withIcon((ItemLike)BlockRegistry.CALCINATION_OVEN.get()).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{intro, intro2});
    }

    private BookEntryModel spagyricsLinkEntry(char location) {
        this.context().entry("spagyrics_link");
        this.add(this.context().entryName(), "Spagyrics");
        this.add(this.context().entryDescription(), "View the Spagyrics Category");
        return this.entry(location).withIcon((ItemLike)BlockRegistry.CALCINATION_OVEN.get()).withCategoryToOpen(Theurgy.loc("spagyrics")).withEntryBackground(EntryBackground.LINK_TO_CATEGORY);
    }

    private BookEntryModel mercuryFluxEntry(char location) {
        this.context().entry("mercury_flux");
        this.add(this.context().entryName(), "Mercury Flux");
        this.add(this.context().entryDescription(), "Mastery over Energy");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Mercury Flux");
        this.add(this.context().pageText(), "Mercury Flux is the raw energy form of Mercury.\n\\\n\\\nMercury Flux Manipulation is the art of controlling this energy to perform and automate various tasks.");
        this.context().page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Learn More");
        this.add(this.context().pageText(), "Open the {0} to learn more about how to obtain and use Mercury Flux.\n", new Object[]{this.categoryLink("Mercury Flux Category", "mercury_flux")});
        return this.entry(location).withIcon((ItemLike)ItemRegistry.MERCURY_SHARD.get()).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{intro, intro2});
    }

    private BookEntryModel mercuryFluxLinkEntry(char location) {
        this.context().entry("mercury_flux_link");
        this.add(this.context().entryName(), "Mercury Flux");
        this.add(this.context().entryDescription(), "View the Mercury Flux Category");
        return this.entry(location).withIcon((ItemLike)ItemRegistry.MERCURY_SHARD.get()).withCategoryToOpen(Theurgy.loc("mercury_flux")).withEntryBackground(EntryBackground.LINK_TO_CATEGORY);
    }
}

