/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.theurgy.content.item.render.AlchemicalSulfurBEWLR;
import com.klikli_dev.theurgy.content.recipe.LiquefactionRecipe;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.util.LevelUtil;
import com.klikli_dev.theurgy.util.TagUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;

public class AlchemicalSulfurItem
extends Item {
    public boolean useAutomaticIconRendering = true;
    public boolean useAutomaticNameRendering = true;
    public boolean provideAutomaticTooltipData = true;
    public boolean overrideTagSourceName = false;
    public boolean overrideSourceName = false;
    public boolean autoGenerateSourceIdInRecipe = true;

    public AlchemicalSulfurItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static String getSourceItemId(ItemStack sulfurStack) {
        if (!sulfurStack.m_41782_()) {
            List<LiquefactionRecipe> liquefactionRecipes;
            Optional<ItemStack> sulfurWithNbt;
            RegistryAccess registryAccess;
            Level level = LevelUtil.getLevelWithoutContext();
            RecipeManager recipeManager = level == null ? null : level.m_7465_();
            RegistryAccess registryAccess2 = registryAccess = level == null ? null : level.m_9598_();
            if (recipeManager != null && (sulfurWithNbt = (liquefactionRecipes = recipeManager.m_44013_((RecipeType)RecipeTypeRegistry.LIQUEFACTION.get()).stream().filter(r -> r.m_8043_(registryAccess) != null).toList()).stream().filter(recipe -> recipe.m_8043_(registryAccess) != null && recipe.m_8043_(registryAccess).m_41720_() == sulfurStack.m_41720_()).findFirst().map(recipe -> recipe.m_8043_(registryAccess))).isPresent() && sulfurWithNbt.get().m_41782_()) {
                sulfurStack.m_41751_(sulfurWithNbt.get().m_41783_());
            }
        }
        if (sulfurStack.m_41782_() && sulfurStack.m_41783_().m_128441_("theurgy:sulfur.source.id")) {
            return sulfurStack.m_41783_().m_128461_("theurgy:sulfur.source.id");
        }
        return "";
    }

    public static ItemStack getSourceStack(ItemStack sulfurStack) {
        String itemSourceId = AlchemicalSulfurItem.getSourceItemId(sulfurStack);
        if (sulfurStack.m_41782_() && sulfurStack.m_41783_().m_128441_("theurgy:sulfur.source.id")) {
            ItemStack sourceStack;
            if (itemSourceId.startsWith("#")) {
                ResourceLocation tagId = new ResourceLocation(itemSourceId.substring(1));
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId);
                sourceStack = TagUtil.getItemStackForTag((TagKey<Item>)tag);
            } else {
                ResourceLocation itemId = new ResourceLocation(itemSourceId);
                sourceStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemId));
            }
            if (sulfurStack.m_41783_().m_128441_("theurgy:sulfur.source.nbt")) {
                sourceStack.m_41751_(sulfurStack.m_41783_().m_128469_("theurgy:sulfur.source.nbt"));
            }
            return sourceStack;
        }
        return ItemStack.f_41583_;
    }

    public static List<MutableComponent> getTooltipData(ItemStack sulfurStack) {
        Item item = sulfurStack.m_41720_();
        if (item instanceof AlchemicalSulfurItem) {
            AlchemicalSulfurItem sulfur = (AlchemicalSulfurItem)item;
            if (sulfur.provideAutomaticTooltipData) {
                return ImmutableList.of((Object)sulfur.getSourceName(sulfurStack));
            }
        }
        return ImmutableList.of();
    }

    public static MutableComponent formatSourceName(MutableComponent sourceName) {
        return sourceName.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131155_(Boolean.valueOf(true)));
    }

    public AlchemicalSulfurItem noAuto() {
        this.useAutomaticIconRendering = false;
        this.useAutomaticNameRendering = false;
        this.provideAutomaticTooltipData = false;
        this.overrideTagSourceName = false;
        return this;
    }

    public AlchemicalSulfurItem autoIcon(boolean value) {
        this.useAutomaticIconRendering = value;
        return this;
    }

    public AlchemicalSulfurItem autoName(boolean value) {
        this.useAutomaticNameRendering = value;
        return this;
    }

    public AlchemicalSulfurItem autoTooltip(boolean value) {
        this.provideAutomaticTooltipData = value;
        return this;
    }

    public AlchemicalSulfurItem overrideTagSourceName(boolean value) {
        this.overrideTagSourceName = value;
        return this;
    }

    public AlchemicalSulfurItem overrideSourceName(boolean value) {
        this.overrideSourceName = value;
        this.autoGenerateSourceIdInRecipe = !value;
        return this;
    }

    public AlchemicalSulfurItem autoGenerateSourceIdInRecipe(boolean value) {
        this.autoGenerateSourceIdInRecipe = value;
        return this;
    }

    public MutableComponent getSourceName(ItemStack pStack) {
        if (this.overrideSourceName) {
            return AlchemicalSulfurItem.formatSourceName(Component.m_237115_((String)(pStack.m_41778_() + ".source")));
        }
        ItemStack source = AlchemicalSulfurItem.getSourceStack(pStack);
        if (!source.m_41619_()) {
            String sourceId = AlchemicalSulfurItem.getSourceItemId(pStack);
            if (sourceId.startsWith("#") && this.overrideTagSourceName) {
                ResourceLocation tagId = new ResourceLocation(sourceId.substring(1));
                return AlchemicalSulfurItem.formatSourceName(Component.m_237115_((String)Util.m_137492_((String)"tag", (ResourceLocation)tagId)));
            }
            Component component = source.m_41786_();
            if (component instanceof MutableComponent) {
                MutableComponent hoverName = (MutableComponent)component;
                return AlchemicalSulfurItem.formatSourceName(hoverName);
            }
        }
        return Component.m_237115_((String)"item.theurgy.alchemical_sulfur.unknown_source");
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return AlchemicalSulfurBEWLR.get();
            }
        });
    }

    public Component m_7626_(ItemStack pStack) {
        if (this.useAutomaticNameRendering) {
            return Component.m_237110_((String)this.m_5671_(pStack), (Object[])new Object[]{ComponentUtils.m_130748_((Component)this.getSourceName(pStack))});
        }
        return super.m_7626_(pStack);
    }
}

