/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.mercurycatalyst;

import com.klikli_dev.theurgy.content.behaviour.CraftingBehaviour;
import com.klikli_dev.theurgy.content.capability.MercuryFluxStorage;
import com.klikli_dev.theurgy.content.recipe.CatalysationRecipe;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;

public class MercuryCatalystCraftingBehaviour
extends CraftingBehaviour<RecipeWrapper, CatalysationRecipe, RecipeManager.CachedCheck<RecipeWrapper, CatalysationRecipe>> {
    private final Supplier<MercuryFluxStorage> mercuryFluxStorageSupplier;
    protected int mercuryFluxToConvert;
    protected int currentMercuryFluxPerTick;

    public MercuryCatalystCraftingBehaviour(BlockEntity blockEntity, Supplier<IItemHandlerModifiable> inputInventorySupplier, Supplier<IItemHandlerModifiable> outputInventorySupplier, Supplier<MercuryFluxStorage> mercuryFluxStorageSupplier) {
        super(blockEntity, Lazy.of(() -> new RecipeWrapper((IItemHandlerModifiable)inputInventorySupplier.get())), inputInventorySupplier, outputInventorySupplier, RecipeManager.m_220267_((RecipeType)((RecipeType)RecipeTypeRegistry.CATALYSATION.get())));
        this.mercuryFluxStorageSupplier = mercuryFluxStorageSupplier;
    }

    @Override
    public boolean canProcess(ItemStack stack) {
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)((IItemHandlerModifiable)this.inputInventorySupplier.get()).getStackInSlot(0))) {
            return true;
        }
        ItemStackHandler tempInv = new ItemStackHandler(NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{stack}));
        RecipeWrapper tempRecipeWrapper = new RecipeWrapper((IItemHandlerModifiable)tempInv);
        return this.recipeCachedCheck.m_213657_((Container)tempRecipeWrapper, this.blockEntity.m_58904_()).isPresent();
    }

    @Override
    public void saveAdditional(CompoundTag pTag) {
        pTag.m_128405_("mercuryFluxToConvert", this.mercuryFluxToConvert);
        pTag.m_128405_("currentMercuryFluxPerTick", this.currentMercuryFluxPerTick);
    }

    @Override
    public void load(CompoundTag pTag) {
        if (pTag.m_128441_("mercuryFluxToConvert")) {
            this.mercuryFluxToConvert = pTag.m_128451_("mercuryFluxToConvert");
        }
        if (pTag.m_128441_("currentMercuryFluxPerTick")) {
            this.currentMercuryFluxPerTick = pTag.m_128451_("currentMercuryFluxPerTick");
        }
    }

    @Override
    protected int getIngredientCount(CatalysationRecipe recipe) {
        return 1;
    }

    @Override
    protected int getCraftingTime(CatalysationRecipe recipe) {
        return -1;
    }

    @Override
    protected int getDefaultCraftingTime() {
        return -1;
    }

    @Override
    protected boolean canCraft(@Nullable CatalysationRecipe pRecipe) {
        if (pRecipe == null) {
            return false;
        }
        MercuryFluxStorage storage = this.mercuryFluxStorageSupplier.get();
        int fluxAccepted = storage.receiveEnergy(pRecipe.getTotalMercuryFlux(), true);
        return fluxAccepted > 0;
    }

    @Override
    public void tickServer(boolean canProcess, boolean hasInput) {
        if (this.mercuryFluxToConvert > 0) {
            if (canProcess) {
                MercuryFluxStorage storage = this.mercuryFluxStorageSupplier.get();
                int maxFluxToConvert = Math.min(this.mercuryFluxToConvert, this.currentMercuryFluxPerTick);
                int fluxAccepted = storage.receiveEnergy(maxFluxToConvert, false);
                this.mercuryFluxToConvert -= fluxAccepted;
            }
        } else if (hasInput) {
            CatalysationRecipe recipe = this.recipeCachedCheck.m_213657_((Container)((RecipeWrapper)this.recipeWrapperSupplier.get()), this.blockEntity.m_58904_()).orElse(null);
            if (canProcess && this.canCraft(recipe)) {
                this.craft(recipe);
            }
        }
    }

    @Override
    protected boolean craft(@Nullable CatalysationRecipe pRecipe) {
        this.mercuryFluxToConvert = pRecipe.getTotalMercuryFlux();
        this.currentMercuryFluxPerTick = pRecipe.getMercuryFluxPerTick();
        ((IItemHandlerModifiable)this.inputInventorySupplier.get()).extractItem(0, this.getIngredientCount(pRecipe), false);
        return true;
    }
}

