/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.mercurycatalyst;

import com.klikli_dev.theurgy.content.apparatus.mercurycatalyst.MercuryCatalystBlockEntity;
import com.klikli_dev.theurgy.content.behaviour.ItemHandlerBehaviour;
import com.klikli_dev.theurgy.content.behaviour.OneSlotItemHandlerBehaviour;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class MercuryCatalystBlock
extends Block
implements EntityBlock {
    protected ItemHandlerBehaviour itemHandlerBehaviour = new OneSlotItemHandlerBehaviour();

    public MercuryCatalystBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.itemHandlerBehaviour.useItemHandler(pState, pLevel, pPos, pPlayer, pHand, pHit) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)BlockEntityRegistry.MERCURY_CATALYST.get()).m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof MercuryCatalystBlockEntity) {
                MercuryCatalystBlockEntity blockEntity = (MercuryCatalystBlockEntity)t;
                blockEntity.tickServer();
            }
        };
    }

    public static int getBlockColor(BlockState pState, BlockAndTintGetter pLevel, BlockPos pPos, int pTintIndex) {
        BlockEntity blockEntity;
        if (pTintIndex != 0 && pLevel != null && pPos != null && (blockEntity = pLevel.m_7702_(pPos)) instanceof MercuryCatalystBlockEntity) {
            MercuryCatalystBlockEntity blockEntity2 = (MercuryCatalystBlockEntity)blockEntity;
            float fillLevel = (float)blockEntity2.mercuryFluxStorage.getEnergyStored() / (float)blockEntity2.mercuryFluxStorage.getMaxEnergyStored();
            return MercuryCatalystBlock.getColorFromFillLevel(fillLevel);
        }
        return 0xFFFFFF;
    }

    public static int getItemColor(ItemStack pStack, int pTintIndex) {
        if (pStack.m_41782_() && pStack.m_41783_().m_128441_("BlockEntityTag")) {
            float fillLevel = (float)pStack.m_41783_().m_128469_("BlockEntityTag").m_128451_("mercuryFluxStorage") / 50000.0f;
            return MercuryCatalystBlock.getColorFromFillLevel(fillLevel);
        }
        return 0xFFFFFF;
    }

    public static int getColorFromFillLevel(float fillLevel) {
        int r = (int)((double)(1.0f - fillLevel) * 255.0);
        int g = (int)((double)(1.0f - fillLevel) * 255.0);
        int b = 255;
        r = Math.max(0, Math.min(255, r));
        g = Math.max(0, Math.min(255, g));
        b = Math.max(0, Math.min(255, b));
        int rgb = r << 16 | g << 8 | b;
        return rgb;
    }
}

