/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron.render;

import com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron.LiquefactionCauldronBlockEntity;
import com.klikli_dev.theurgy.content.render.RenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

public class LiquefactionCauldronRenderer
implements BlockEntityRenderer<LiquefactionCauldronBlockEntity> {
    public LiquefactionCauldronRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    private static void putVertex(VertexConsumer builder, PoseStack ms, float x, float y, float z, int color, float u, float v, Direction face, int light) {
        Vec3i normal = face.m_122436_();
        PoseStack.Pose peek = ms.m_85850_();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.m_252986_(peek.m_252922_(), x, y, z).m_6122_(r, g, b, a).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(peek.m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
    }

    public void render(LiquefactionCauldronBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (pBlockEntity.solventTank.isEmpty()) {
            return;
        }
        FluidStack fluidStack = pBlockEntity.solventTank.getFluid();
        Fluid fluid = fluidStack.getFluid();
        FluidType fluidType = fluid.getFluidType();
        IClientFluidTypeExtensions fluidClientExtension = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite fluidTexture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidClientExtension.getStillTexture(fluidStack));
        int color = fluidClientExtension.getTintColor(fluidStack);
        int blockLightIn = pPackedLight >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluidType.getLightLevel(fluidStack));
        int fluidLight = pPackedLight & 0xF00000 | luminosity << 4;
        float fluidHeight = (float)fluidStack.getAmount() / (float)pBlockEntity.solventTank.getCapacity();
        fluidHeight *= 0.875f;
        pPoseStack.m_85836_();
        float min = 0.25f;
        float max = 1.0f - min;
        VertexConsumer builder = pBufferSource.m_6299_(RenderTypes.fluid());
        LiquefactionCauldronRenderer.putVertex(builder, pPoseStack, min, fluidHeight += 0.25f, min, color, fluidTexture.m_118367_(2.0), fluidTexture.m_118393_(2.0), Direction.UP, fluidLight);
        LiquefactionCauldronRenderer.putVertex(builder, pPoseStack, min, fluidHeight, max, color, fluidTexture.m_118367_(14.0), fluidTexture.m_118393_(2.0), Direction.UP, fluidLight);
        LiquefactionCauldronRenderer.putVertex(builder, pPoseStack, max, fluidHeight, max, color, fluidTexture.m_118367_(14.0), fluidTexture.m_118393_(14.0), Direction.UP, fluidLight);
        LiquefactionCauldronRenderer.putVertex(builder, pPoseStack, max, fluidHeight, min, color, fluidTexture.m_118367_(2.0), fluidTexture.m_118393_(14.0), Direction.UP, fluidLight);
        pPoseStack.m_85849_();
    }
}

