/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.incubator;

import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorBlockEntity;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IncubatorSaltVesselBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public IncubatorBlockEntity incubator;
    public ItemStackHandler inputInventory = new InputInventory();
    public LazyOptional<IItemHandler> inputInventoryCapability = LazyOptional.of(() -> this.inputInventory);

    public IncubatorSaltVesselBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.INCUBATOR_SALT_VESSEL.get(), pPos, pBlockState);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inputInventory", (Tag)this.inputInventory.serializeNBT());
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("inputInventory")) {
            this.inputInventory.deserializeNBT(pTag.m_128469_("inputInventory"));
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inputInventoryCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inputInventoryCapability.invalidate();
    }

    public void setIncubator(IncubatorBlockEntity incubator) {
        this.incubator = incubator;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public class InputInventory
    extends ItemStackHandler {
        public InputInventory() {
            super(1);
        }

        public void setStackInSlot(int slot, @NotNull ItemStack newStack) {
            ItemStack oldStack = this.getStackInSlot(slot);
            boolean sameItem = !newStack.m_41619_() && ItemStack.m_150942_((ItemStack)newStack, (ItemStack)oldStack);
            super.setStackInSlot(slot, newStack);
            if (!sameItem && IncubatorSaltVesselBlockEntity.this.incubator != null) {
                IncubatorSaltVesselBlockEntity.this.incubator.onVesselItemChanged();
            }
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack newStack, boolean simulate) {
            if (!simulate) {
                ItemStack oldStack = this.getStackInSlot(slot);
                ItemStack result = super.insertItem(slot, newStack, simulate);
                if (result != newStack && IncubatorSaltVesselBlockEntity.this.incubator != null) {
                    IncubatorSaltVesselBlockEntity.this.incubator.craftingBehaviour.onInputItemChanged(oldStack, newStack);
                }
                return result;
            }
            return super.insertItem(slot, newStack, simulate);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_204117_(ItemTagRegistry.ALCHEMICAL_SALTS) && super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            IncubatorSaltVesselBlockEntity.this.m_6596_();
        }
    }
}

