/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.caloricfluxemitter;

import com.klikli_dev.theurgy.content.apparatus.caloricfluxemitter.CaloricFluxEmitterBlock;
import com.klikli_dev.theurgy.content.apparatus.caloricfluxemitter.CaloricFluxEmitterSelectedPoint;
import com.klikli_dev.theurgy.content.behaviour.interaction.SelectionBehaviour;
import com.klikli_dev.theurgy.content.capability.DefaultMercuryFluxStorage;
import com.klikli_dev.theurgy.content.capability.HeatReceiver;
import com.klikli_dev.theurgy.network.Networking;
import com.klikli_dev.theurgy.network.messages.MessageShowCaloricFlux;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.CapabilityRegistry;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaloricFluxEmitterBlockEntity
extends BlockEntity {
    public static final int CAPACITY = 1000;
    public static final int FLUX_PER_HEAT = 100;
    public static final int HEAT_TARGET_FOR_TICKS = 120;
    public static final int TICK_INTERVAL = 20;
    public MercuryFluxStorage mercuryFluxStorage = new MercuryFluxStorage(1000);
    public LazyOptional<MercuryFluxStorage> mercuryFluxStorageCapability = LazyOptional.of(() -> this.mercuryFluxStorage);
    protected List<CaloricFluxEmitterSelectedPoint> selectedPoints = new ArrayList<CaloricFluxEmitterSelectedPoint>();

    public CaloricFluxEmitterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.CALORIC_FLUX_EMITTER.get(), pPos, pBlockState);
    }

    public void onLoad() {
        this.selectedPoints.forEach(point -> point.setLevel(this.m_58904_()));
    }

    public void tickServer() {
        if (this.m_58904_().m_46467_() % 20L != 0L) {
            return;
        }
        if (this.selectedPoints.isEmpty()) {
            return;
        }
        CaloricFluxEmitterSelectedPoint selectedPoint = this.selectedPoints.get(0);
        if (!this.getSelectionBehaviour().isValid(selectedPoint)) {
            return;
        }
        if (this.mercuryFluxStorage.getEnergyStored() >= 100) {
            BlockEntity blockEntity = this.m_58904_().m_7702_(selectedPoint.getBlockPos());
            HeatReceiver heatReceiver = (HeatReceiver)blockEntity.getCapability(CapabilityRegistry.HEAT_RECEIVER).orElse(null);
            if (heatReceiver.getIsHotUntil() > this.m_58904_().m_46467_() + 20L) {
                return;
            }
            this.mercuryFluxStorage.extractEnergy(100, false);
            heatReceiver.setHotUntil(this.m_58904_().m_46467_() + 120L);
            Networking.sendToTracking(this.m_58904_().m_46745_(this.m_58899_()), new MessageShowCaloricFlux(this.m_58899_(), selectedPoint.getBlockPos(), (Direction)this.m_58900_().m_61143_((Property)CaloricFluxEmitterBlock.f_52588_)));
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityRegistry.MERCURY_FLUX) {
            return this.mercuryFluxStorageCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.mercuryFluxStorageCapability.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("mercuryFluxStorage", this.mercuryFluxStorage.serializeNBT());
        pTag.m_128365_("selectedPoints", (Tag)Util.m_260975_((DataResult)CaloricFluxEmitterSelectedPoint.LIST_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.selectedPoints), e -> new EncoderException("Failed to encode: " + e + " " + this.selectedPoints)));
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("mercuryFluxStorage")) {
            this.mercuryFluxStorage.deserializeNBT(pTag.m_128423_("mercuryFluxStorage"));
        }
        if (pTag.m_128441_("selectedPoints")) {
            this.selectedPoints = (List)Util.m_260975_((DataResult)CaloricFluxEmitterSelectedPoint.LIST_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)pTag.m_128423_("selectedPoints")), e -> new EncoderException("Failed to decode: " + e + " " + pTag.m_128423_("selectedPoints")));
        }
    }

    public SelectionBehaviour<CaloricFluxEmitterSelectedPoint> getSelectionBehaviour() {
        return ((CaloricFluxEmitterBlock)((Object)BlockRegistry.CALORIC_FLUX_EMITTER.get())).getSelectionBehaviour();
    }

    public void setSelectedPoints(List<CaloricFluxEmitterSelectedPoint> selectedPoints) {
        this.selectedPoints = selectedPoints;
        this.selectedPoints.removeIf(p -> !p.getBlockPos().m_123314_((Vec3i)this.m_58899_(), (double)this.getSelectionBehaviour().getBlockRange()));
        this.m_6596_();
    }

    public class MercuryFluxStorage
    extends DefaultMercuryFluxStorage {
        public MercuryFluxStorage(int capacity) {
            super(capacity);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = super.receiveEnergy(maxReceive, simulate);
            if (received > 0) {
                CaloricFluxEmitterBlockEntity.this.m_6596_();
            }
            return received;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = super.extractEnergy(maxExtract, simulate);
            if (extracted > 0) {
                CaloricFluxEmitterBlockEntity.this.m_6596_();
            }
            return extracted;
        }
    }
}

