/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.calcinationoven;

import com.klikli_dev.theurgy.content.apparatus.calcinationoven.CalcinationCraftingBehaviour;
import com.klikli_dev.theurgy.content.apparatus.calcinationoven.CalcinationOvenAnimationBehaviour;
import com.klikli_dev.theurgy.content.behaviour.AnimationBehaviour;
import com.klikli_dev.theurgy.content.behaviour.CraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.HeatConsumerBehaviour;
import com.klikli_dev.theurgy.content.behaviour.PreventInsertWrapper;
import com.klikli_dev.theurgy.content.capability.DefaultHeatReceiver;
import com.klikli_dev.theurgy.content.capability.HeatReceiver;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.CapabilityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class CalcinationOvenBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    public ItemStackHandler inputInventory = new InputInventory();
    public LazyOptional<IItemHandler> inputInventoryCapability = LazyOptional.of(() -> this.inputInventory);
    public ItemStackHandler outputInventory = new OutputInventory();
    public PreventInsertWrapper outputInventoryTakeOnlyWrapper = new PreventInsertWrapper((IItemHandlerModifiable)this.outputInventory);
    public LazyOptional<IItemHandler> outputInventoryCapability = LazyOptional.of(() -> this.outputInventoryTakeOnlyWrapper);
    public CombinedInvWrapper inventory = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventoryTakeOnlyWrapper});
    public LazyOptional<IItemHandler> inventoryCapability = LazyOptional.of(() -> this.inventory);
    public DefaultHeatReceiver heatReceiver = new DefaultHeatReceiver();
    public LazyOptional<HeatReceiver> heatReceiverCapability = LazyOptional.of(() -> this.heatReceiver);
    protected CraftingBehaviour<?, ?, ?> craftingBehaviour = new CalcinationCraftingBehaviour(this, () -> this.inputInventory, () -> this.outputInventory);
    protected HeatConsumerBehaviour heatConsumerBehaviour = new HeatConsumerBehaviour(this);
    protected AnimationBehaviour<?> animationBehaviour = new CalcinationOvenAnimationBehaviour(this);

    public CalcinationOvenBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.CALCINATION_OVEN.get(), pPos, pBlockState);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.writeNetwork(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readNetwork(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.readNetwork(tag);
        }
    }

    public void readNetwork(CompoundTag tag) {
        this.craftingBehaviour.readNetwork(tag);
    }

    public void writeNetwork(CompoundTag tag) {
        this.craftingBehaviour.writeNetwork(tag);
    }

    public void tickServer() {
        boolean isHeated = this.heatConsumerBehaviour.isHeated();
        boolean hasInput = !this.inputInventory.getStackInSlot(0).m_41619_();
        this.craftingBehaviour.tickServer(isHeated, hasInput);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.UP) {
                return this.inputInventoryCapability.cast();
            }
            if (side == Direction.DOWN) {
                return this.outputInventoryCapability.cast();
            }
            return this.inventoryCapability.cast();
        }
        if (cap == CapabilityRegistry.HEAT_RECEIVER) {
            return this.heatReceiverCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCapability.invalidate();
        this.inputInventoryCapability.invalidate();
        this.outputInventoryCapability.invalidate();
        this.heatReceiverCapability.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inputInventory", (Tag)this.inputInventory.serializeNBT());
        pTag.m_128365_("outputInventory", (Tag)this.outputInventory.serializeNBT());
        pTag.m_128365_("heatReceiver", this.heatReceiver.serializeNBT());
        this.craftingBehaviour.saveAdditional(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("inputInventory")) {
            this.inputInventory.deserializeNBT(pTag.m_128469_("inputInventory"));
        }
        if (pTag.m_128441_("outputInventory")) {
            this.outputInventory.deserializeNBT(pTag.m_128469_("outputInventory"));
        }
        if (pTag.m_128441_("heatReceiver")) {
            this.heatReceiver.deserializeNBT(pTag.m_128423_("heatReceiver"));
        }
        this.craftingBehaviour.load(pTag);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController[] animationControllerArray = new AnimationController[1];
        animationControllerArray[0] = new AnimationController((GeoAnimatable)this, "controller", 10, this.animationBehaviour::animationHandler);
        controllerRegistrar.add(animationControllerArray);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationBehaviour.getAnimatableInstanceCache();
    }

    public class InputInventory
    extends ItemStackHandler {
        public InputInventory() {
            super(1);
        }

        public void setStackInSlot(int slot, @NotNull ItemStack newStack) {
            ItemStack oldStack = this.getStackInSlot(slot);
            boolean sameItem = !newStack.m_41619_() && ItemStack.m_150942_((ItemStack)newStack, (ItemStack)oldStack);
            super.setStackInSlot(slot, newStack);
            if (!sameItem) {
                CalcinationOvenBlockEntity.this.craftingBehaviour.onInputItemChanged(oldStack, newStack);
            }
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack newStack, boolean simulate) {
            if (!simulate) {
                ItemStack oldStack = this.getStackInSlot(slot);
                ItemStack result = super.insertItem(slot, newStack, simulate);
                if (result != newStack) {
                    CalcinationOvenBlockEntity.this.craftingBehaviour.onInputItemChanged(oldStack, newStack);
                }
                return result;
            }
            return super.insertItem(slot, newStack, simulate);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return CalcinationOvenBlockEntity.this.craftingBehaviour.canProcess(stack) && super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            CalcinationOvenBlockEntity.this.m_6596_();
        }
    }

    public class OutputInventory
    extends ItemStackHandler {
        public OutputInventory() {
            super(1);
        }

        protected void onContentsChanged(int slot) {
            CalcinationOvenBlockEntity.this.m_6596_();
        }
    }
}

