/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.modonomicon.page.accumulation;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.page.BookRecipePage;
import com.klikli_dev.theurgy.content.recipe.AccumulationRecipe;
import com.klikli_dev.theurgy.integration.modonomicon.TheurgyModonomiconConstants;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class BookAccumulationRecipePage
extends BookRecipePage<AccumulationRecipe> {
    public BookAccumulationRecipePage(BookTextHolder title1, ResourceLocation recipeId1, BookTextHolder title2, ResourceLocation recipeId2, BookTextHolder text, String anchor) {
        super((RecipeType)RecipeTypeRegistry.ACCUMULATION.get(), title1, recipeId1, title2, recipeId2, text, anchor);
    }

    public static BookAccumulationRecipePage fromJson(JsonObject json) {
        BookRecipePage.DataHolder common = BookRecipePage.commonFromJson((JsonObject)json);
        String anchor = GsonHelper.m_13851_((JsonObject)json, (String)"anchor", (String)"");
        return new BookAccumulationRecipePage(common.title1(), common.recipeId1(), common.title2(), common.recipeId2(), common.text(), anchor);
    }

    public static BookAccumulationRecipePage fromNetwork(FriendlyByteBuf buffer) {
        BookRecipePage.DataHolder common = BookRecipePage.commonFromNetwork((FriendlyByteBuf)buffer);
        String anchor = buffer.m_130277_();
        return new BookAccumulationRecipePage(common.title1(), common.recipeId1(), common.title2(), common.recipeId2(), common.text(), anchor);
    }

    public ResourceLocation getType() {
        return TheurgyModonomiconConstants.Page.ACCUMULATION_RECIPE;
    }

    public void build(Level level, BookEntry parentEntry, int pageNum) {
        this.parentEntry = parentEntry;
        this.pageNumber = pageNum;
        this.book = this.parentEntry.getBook();
        this.recipe1 = this.loadRecipe(level, parentEntry, this.recipeId1);
        this.recipe2 = this.loadRecipe(level, parentEntry, this.recipeId2);
        if (this.recipe1 == null && this.recipe2 != null) {
            this.recipe1 = this.recipe2;
            this.recipe2 = null;
        }
        if (this.title1.isEmpty()) {
            this.title1 = new BookTextHolder((Component)((MutableComponent)((AccumulationRecipe)this.recipe1).getResult().getDisplayName()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (this.recipe2 != null && this.title2.isEmpty()) {
            this.title2 = new BookTextHolder((Component)((MutableComponent)((AccumulationRecipe)this.recipe2).getResult().getDisplayName()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (this.title1.equals((Object)this.title2)) {
            this.title2 = BookTextHolder.EMPTY;
        }
    }

    protected ItemStack getRecipeOutput(Level level, AccumulationRecipe recipe) {
        return ItemStack.f_41583_;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        super.toNetwork(buffer);
        buffer.m_130070_(this.anchor);
    }
}

