/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.jei.recipes;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.klikli_dev.theurgy.content.gui.GuiTextures;
import com.klikli_dev.theurgy.content.recipe.ReformationRecipe;
import com.klikli_dev.theurgy.integration.jei.JeiDrawables;
import com.klikli_dev.theurgy.integration.jei.JeiRecipeTypes;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ReformationCategory
implements IRecipeCategory<ReformationRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;
    private final LoadingCache<Integer, IDrawableAnimated> cachedAnimatedArrow;

    public ReformationCategory(final IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(180, 100);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)BlockRegistry.REFORMATION_RESULT_PEDESTAL.get()));
        this.localizedName = Component.m_237115_((String)"theurgy.jei.category.reformation");
        this.cachedAnimatedArrow = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return JeiDrawables.asAnimatedDrawable(guiHelper, GuiTextures.JEI_ARROW_RIGHT_FULL, cookTime, IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    protected IDrawableAnimated getAnimatedArrow(ReformationRecipe recipe) {
        int cookTime = recipe.getReformationTime();
        if (cookTime <= 0) {
            cookTime = 100;
        }
        return (IDrawableAnimated)this.cachedAnimatedArrow.getUnchecked((Object)cookTime);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(ReformationRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        GuiTextures.JEI_ARROW_RIGHT_EMPTY.render(guiGraphics, 19, 19);
        GuiTextures.JEI_ARROW_RIGHT_EMPTY.render(guiGraphics, 130, 19);
        this.getAnimatedArrow(recipe).draw(guiGraphics, 130, 19);
        GuiTextures.JEI_ARROW_RIGHT_EMPTY.render(guiGraphics, 65, 19);
        this.drawCookTime(recipe, guiGraphics, 37);
        this.drawFlux(recipe, guiGraphics, 90);
        this.drawSourcePedestalCount(recipe, guiGraphics, 78);
        RenderSystem.enableDepthTest();
        ItemStack barrier = new ItemStack((ItemLike)Items.f_42127_);
        Font font = Minecraft.m_91087_().f_91062_;
        guiGraphics.m_280203_(barrier, 45, 1);
        guiGraphics.m_280370_(font, barrier, 45, 1);
        RenderSystem.disableBlend();
    }

    protected void drawCookTime(ReformationRecipe recipe, GuiGraphics guiGraphics, int y) {
        int cookTime = recipe.getReformationTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.m_91087_();
            Font font = minecraft.f_91062_;
            int stringWidth = font.m_92852_((FormattedText)timeString);
            guiGraphics.m_280614_(font, (Component)timeString, 140 - stringWidth / 2, y, -8355712, false);
        }
    }

    protected void drawFlux(ReformationRecipe recipe, GuiGraphics guiGraphics, int y) {
        int flux = recipe.getMercuryFlux();
        MutableComponent timeString = Component.m_237110_((String)"theurgy.jei.misc.mercury_flux", (Object[])new Object[]{flux});
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        guiGraphics.m_280614_(font, (Component)timeString, 1, y, -8355712, false);
    }

    protected void drawSourcePedestalCount(ReformationRecipe recipe, GuiGraphics guiGraphics, int y) {
        int count = recipe.getSources().size();
        MutableComponent timeString = Component.m_237110_((String)"theurgy.jei.misc.source_pedestal_count", (Object[])new Object[]{count});
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        int stringWidth = font.m_92852_((FormattedText)timeString);
        guiGraphics.m_280614_(font, (Component)timeString, 95 - stringWidth, y, -8355712, false);
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ReformationRecipe recipe, IFocusGroup focuses) {
        int startY;
        builder.addSlot(RecipeIngredientRole.CATALYST, 1, 15).addItemStack(new ItemStack((ItemLike)ItemRegistry.SULFURIC_FLUX_EMITTER.get()));
        builder.addSlot(RecipeIngredientRole.CATALYST, 45, 19).setBackground(JeiDrawables.INPUT_SLOT, -1, -1).addIngredients(recipe.getTarget());
        builder.addSlot(RecipeIngredientRole.CATALYST, 45, 35).addItemStack(new ItemStack((ItemLike)ItemRegistry.REFORMATION_TARGET_PEDESTAL.get()));
        int sourceSlotX = 90;
        int sourceSlotY = startY = 55;
        for (int i = 0; i < 8; ++i) {
            IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, sourceSlotX, sourceSlotY).setBackground(JeiDrawables.INPUT_SLOT, -1, -1);
            if (i < recipe.getSources().size()) {
                slot.addIngredients(recipe.getSources().get(i));
            }
            sourceSlotY -= 18;
            if (i % 4 != 3) continue;
            sourceSlotY = startY;
            sourceSlotX += 18;
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 99, startY + 18).addItemStack(new ItemStack((ItemLike)ItemRegistry.REFORMATION_SOURCE_PEDESTAL.get()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 160, 19).setBackground(JeiDrawables.OUTPUT_SLOT, -5, -5).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
        builder.addSlot(RecipeIngredientRole.CATALYST, 160, 42).addItemStack(new ItemStack((ItemLike)ItemRegistry.REFORMATION_RESULT_PEDESTAL.get()));
    }

    public RecipeType<ReformationRecipe> getRecipeType() {
        return JeiRecipeTypes.REFORMATION;
    }

    public List<Component> getTooltipStrings(ReformationRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 45.0 && mouseX < 63.0 && mouseY > 1.0 && mouseY < 19.0) {
            return List.of(Component.m_237115_((String)"theurgy.jei.misc.source_sulfur.tooltip").m_130940_(ChatFormatting.ITALIC));
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }
}

