/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.jade;

import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.content.capability.MercuryFluxStorage;
import com.klikli_dev.theurgy.registry.CapabilityRegistry;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;

public class MercuryFluxEnergyProvider
implements IServerExtensionProvider<Object, CompoundTag>,
IClientExtensionProvider<CompoundTag, EnergyView> {
    public static final ResourceLocation ID = Theurgy.loc("mercury_flux");
    private static final MercuryFluxEnergyProvider instance = new MercuryFluxEnergyProvider();

    public static MercuryFluxEnergyProvider get() {
        return instance;
    }

    public static List<ViewGroup<CompoundTag>> wrapMercuryFluxStorage(Object target, @Nullable Player player) {
        CapabilityProvider capProvider;
        MercuryFluxStorage storage;
        if (target instanceof CapabilityProvider && (storage = (MercuryFluxStorage)(capProvider = (CapabilityProvider)target).getCapability(CapabilityRegistry.MERCURY_FLUX).orElse(null)) != null) {
            ViewGroup group = new ViewGroup(List.of(EnergyView.of((long)storage.getEnergyStored(), (long)storage.getMaxEnergyStored())));
            group.getExtraData().m_128359_("Unit", "MF");
            return List.of(group);
        }
        return null;
    }

    public List<ClientViewGroup<EnergyView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<CompoundTag>> groups) {
        return groups.stream().map($ -> {
            String unit = $.getExtraData().m_128461_("Unit");
            return new ClientViewGroup($.views.stream().map(tag -> EnergyView.read((CompoundTag)tag, (String)unit)).filter(Objects::nonNull).toList());
        }).toList();
    }

    public List<ViewGroup<CompoundTag>> getGroups(ServerPlayer player, ServerLevel level, Object target, boolean showDetails) {
        return MercuryFluxEnergyProvider.wrapMercuryFluxStorage(target, (Player)player);
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

