/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class SmeltingRecipeProvider
extends JsonRecipeProvider {
    public SmeltingRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "smelting");
    }

    @Override
    void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
    }

    public void makeRecipe(String name, RecipeBuilder recipe) {
        this.recipeConsumer.accept(this.modLoc(name), recipe.build());
    }

    public String m_6055_() {
        return "Smelting Recipes";
    }

    private class RecipeBuilder {
        JsonObject recipe = new JsonObject();

        public RecipeBuilder(ItemLike result) {
            this(result, 1);
        }

        public RecipeBuilder(ItemLike result, int count) {
            this(result, count, null);
        }

        public RecipeBuilder(ItemLike result, @Nullable int count, JsonObject nbt) {
            this(smeltingRecipeProvider.makeItemResult(smeltingRecipeProvider.locFor(result), count, nbt));
        }

        public RecipeBuilder(JsonObject result) {
            this.recipe.addProperty("type", ForgeRegistries.RECIPE_SERIALIZERS.getKey((Object)RecipeSerializer.f_44091_).toString());
            this.recipe.add("result", (JsonElement)result);
            this.recipe.addProperty("cookingtime", (Number)200);
            this.recipe.addProperty("experience", (Number)Float.valueOf(0.7f));
        }

        public RecipeBuilder time(int time) {
            this.recipe.addProperty("cookingtime", (Number)time);
            return this;
        }

        public RecipeBuilder experience(float exp) {
            this.recipe.addProperty("experience", (Number)Float.valueOf(exp));
            return this;
        }

        public RecipeBuilder requires(TagKey<Item> tag) {
            return this.requires(SmeltingRecipeProvider.this.makeTagIngredient(SmeltingRecipeProvider.this.locFor(tag)));
        }

        public RecipeBuilder requires(ItemLike item) {
            return this.requires(SmeltingRecipeProvider.this.makeItemIngredient(SmeltingRecipeProvider.this.locFor(item)));
        }

        public RecipeBuilder requires(JsonObject ingredient) {
            this.recipe.add("ingredient", (JsonElement)ingredient);
            return this;
        }

        public JsonObject build() {
            return this.recipe;
        }
    }
}

