/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.content.item.DivinationRodItem;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ShapedRecipeProvider
extends JsonRecipeProvider {
    public ShapedRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "crafting/shaped");
    }

    @Override
    void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.makeRecipe("divination_rod_t1", new RecipeBuilder((ItemLike)ItemRegistry.DIVINATION_ROD_T1.get(), 1, this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.DIVINATION_ROD_T1.get()))).pattern(" GR").pattern(" RG").pattern("R  ").define('G', (TagKey<Item>)Tags.Items.GLASS).define('R', (TagKey<Item>)Tags.Items.RODS_WOODEN));
        JsonObject amethystDivinationRodSettings = this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.AMETHYST_DIVINATION_ROD.get()));
        amethystDivinationRodSettings.addProperty("theurgy:divination.linked_block_id", "minecraft:budding_amethyst");
        this.makeRecipe("amethyst_divination_rod", new RecipeBuilder((ItemLike)ItemRegistry.AMETHYST_DIVINATION_ROD.get(), 1, amethystDivinationRodSettings).pattern(" GP").pattern(" RG").pattern("R  ").define('P', (TagKey<Item>)Tags.Items.DYES_PURPLE).define('G', (TagKey<Item>)Tags.Items.GLASS).define('R', (TagKey<Item>)Tags.Items.RODS_WOODEN));
        this.makeRecipe("sulfur_attuned_divination_rod_abundant", new RecipeBuilder((ItemLike)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_ABUNDANT.get(), 1, this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_ABUNDANT.get())), "theurgy:divination_rod").pattern(" GS").pattern(" RG").pattern("R  ").define('G', (TagKey<Item>)Tags.Items.GLASS).define('R', (TagKey<Item>)Tags.Items.RODS_WOODEN).define('S', ItemTagRegistry.ALCHEMICAL_SULFURS_ABUNDANT));
        this.makeRecipe("sulfur_attuned_divination_rod_common", new RecipeBuilder((ItemLike)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_COMMON.get(), 1, this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_COMMON.get())), "theurgy:divination_rod").pattern(" GS").pattern(" RG").pattern("R  ").define('G', (TagKey<Item>)Tags.Items.GLASS).define('R', (TagKey<Item>)Tags.Items.RODS_WOODEN).define('S', ItemTagRegistry.ALCHEMICAL_SULFURS_COMMON));
        this.makeRecipe("divination_rod_t2", new RecipeBuilder((ItemLike)ItemRegistry.DIVINATION_ROD_T2.get(), 1, this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.DIVINATION_ROD_T2.get()))).pattern(" GM").pattern(" AG").pattern("R  ").define('G', (TagKey<Item>)Tags.Items.GLASS).define('R', (TagKey<Item>)Tags.Items.RODS_WOODEN).define('A', (TagKey<Item>)Tags.Items.GEMS_AMETHYST).define('M', (TagKey<Item>)Tags.Items.NUGGETS_GOLD));
        this.makeRecipe("sulfur_attuned_divination_rod_rare", new RecipeBuilder((ItemLike)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_RARE.get(), 1, this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_RARE.get())), "theurgy:divination_rod").pattern(" GS").pattern(" AG").pattern("R  ").define('G', (TagKey<Item>)Tags.Items.GLASS).define('R', (TagKey<Item>)Tags.Items.RODS_WOODEN).define('A', (TagKey<Item>)Tags.Items.GEMS_AMETHYST).define('S', ItemTagRegistry.ALCHEMICAL_SULFURS_RARE));
        this.makeRecipe("divination_rod_t3", new RecipeBuilder((ItemLike)ItemRegistry.DIVINATION_ROD_T3.get(), 1, this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.DIVINATION_ROD_T3.get()))).pattern(" GD").pattern(" QG").pattern("A  ").define('G', (TagKey<Item>)Tags.Items.GLASS).define('Q', (TagKey<Item>)Tags.Items.GEMS_QUARTZ).define('D', (TagKey<Item>)Tags.Items.GEMS_DIAMOND).define('A', (TagKey<Item>)Tags.Items.GEMS_AMETHYST));
        this.makeRecipe("sulfur_attuned_divination_rod_precious", new RecipeBuilder((ItemLike)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_PRECIOUS.get(), 1, this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_PRECIOUS.get())), "theurgy:divination_rod").pattern(" GS").pattern(" DG").pattern("A  ").define('G', (TagKey<Item>)Tags.Items.GLASS).define('D', (TagKey<Item>)Tags.Items.GEMS_DIAMOND).define('A', (TagKey<Item>)Tags.Items.GEMS_AMETHYST).define('S', ItemTagRegistry.ALCHEMICAL_SULFURS_PRECIOUS));
        this.makeRecipe("divination_rod_t4", new RecipeBuilder((ItemLike)ItemRegistry.DIVINATION_ROD_T4.get(), 1, this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.DIVINATION_ROD_T4.get()))).pattern(" GM").pattern(" RG").pattern("A  ").define('G', (TagKey<Item>)Tags.Items.GLASS).define('R', (TagKey<Item>)Tags.Items.RODS_BLAZE).define('M', (TagKey<Item>)Tags.Items.ORES_NETHERITE_SCRAP).define('A', (TagKey<Item>)Tags.Items.GEMS_AMETHYST));
        this.makeRecipe((ItemLike)ItemRegistry.PYROMANTIC_BRAZIER.get(), new RecipeBuilder((ItemLike)ItemRegistry.PYROMANTIC_BRAZIER.get(), 1).pattern("CCC").pattern("CSC").pattern("SSS").define('C', (TagKey<Item>)Tags.Items.INGOTS_COPPER).define('S', (TagKey<Item>)Tags.Items.STONE));
        this.makeRecipe((ItemLike)ItemRegistry.CALCINATION_OVEN.get(), new RecipeBuilder((ItemLike)ItemRegistry.CALCINATION_OVEN.get(), 1).pattern(" I ").pattern("ICI").pattern(" I ").define('C', (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COPPER).define('I', (TagKey<Item>)Tags.Items.INGOTS_IRON));
        this.makeRecipe((ItemLike)ItemRegistry.DISTILLER.get(), new RecipeBuilder((ItemLike)ItemRegistry.DISTILLER.get(), 1).pattern(" I ").pattern("ICI").pattern("SSS").define('C', (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COPPER).define('I', (TagKey<Item>)Tags.Items.INGOTS_IRON).define('S', (TagKey<Item>)Tags.Items.STONE));
        this.makeRecipe((ItemLike)ItemRegistry.LIQUEFACTION_CAULDRON.get(), new RecipeBuilder((ItemLike)ItemRegistry.LIQUEFACTION_CAULDRON.get(), 1).pattern("CCC").pattern("CBC").pattern("SSS").define('C', (TagKey<Item>)Tags.Items.INGOTS_COPPER).define('B', (ItemLike)Items.f_42544_).define('S', (TagKey<Item>)Tags.Items.STONE));
        this.makeRecipe((ItemLike)ItemRegistry.SAL_AMMONIAC_ACCUMULATOR.get(), new RecipeBuilder((ItemLike)ItemRegistry.SAL_AMMONIAC_ACCUMULATOR.get(), 1).pattern("SSS").pattern("III").pattern("R R").define('R', (TagKey<Item>)Tags.Items.RODS_WOODEN).define('I', (TagKey<Item>)Tags.Items.INGOTS_IRON).define('S', (TagKey<Item>)Tags.Items.STONE));
        this.makeRecipe((ItemLike)ItemRegistry.SAL_AMMONIAC_TANK.get(), new RecipeBuilder((ItemLike)ItemRegistry.SAL_AMMONIAC_TANK.get(), 1).pattern("ICI").pattern("ICI").pattern("RCR").define('R', (TagKey<Item>)Tags.Items.RODS_WOODEN).define('C', (TagKey<Item>)Tags.Items.INGOTS_COPPER).define('I', (TagKey<Item>)Tags.Items.INGOTS_IRON));
        this.makeRecipe((ItemLike)ItemRegistry.INCUBATOR.get(), new RecipeBuilder((ItemLike)ItemRegistry.INCUBATOR.get(), 1).pattern("PSP").pattern("GGG").pattern("SCS").define('P', (TagKey<Item>)ItemTags.f_13168_).define('C', (TagKey<Item>)Tags.Items.INGOTS_COPPER).define('G', (TagKey<Item>)Tags.Items.INGOTS_GOLD).define('S', (TagKey<Item>)Tags.Items.STONE));
        this.makeRecipe((ItemLike)ItemRegistry.INCUBATOR_MERCURY_VESSEL.get(), new RecipeBuilder((ItemLike)ItemRegistry.INCUBATOR_MERCURY_VESSEL.get(), 1).pattern("cMc").pattern("c c").pattern("SSS").define('c', (TagKey<Item>)Tags.Items.INGOTS_COPPER).define('M', ItemTagRegistry.ALCHEMICAL_MERCURIES).define('S', (TagKey<Item>)Tags.Items.STONE));
        this.makeRecipe((ItemLike)ItemRegistry.INCUBATOR_SALT_VESSEL.get(), new RecipeBuilder((ItemLike)ItemRegistry.INCUBATOR_SALT_VESSEL.get(), 1).pattern("csc").pattern("c c").pattern("SSS").define('c', (TagKey<Item>)Tags.Items.INGOTS_COPPER).define('s', ItemTagRegistry.ALCHEMICAL_SALTS).define('S', (TagKey<Item>)Tags.Items.STONE));
        this.makeRecipe((ItemLike)ItemRegistry.INCUBATOR_SULFUR_VESSEL.get(), new RecipeBuilder((ItemLike)ItemRegistry.INCUBATOR_SULFUR_VESSEL.get(), 1).pattern("csc").pattern("c c").pattern("SSS").define('c', (TagKey<Item>)Tags.Items.INGOTS_COPPER).define('s', ItemTagRegistry.ALCHEMICAL_SULFURS).define('S', (TagKey<Item>)Tags.Items.STONE));
        this.makeRecipe((ItemLike)ItemRegistry.MERCURY_CATALYST.get(), new RecipeBuilder((ItemLike)ItemRegistry.MERCURY_CATALYST.get(), 1).pattern("imi").pattern("gQg").pattern("igi").define('Q', (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_QUARTZ).define('g', (TagKey<Item>)Tags.Items.INGOTS_GOLD).define('i', (TagKey<Item>)Tags.Items.INGOTS_IRON).define('m', ItemTagRegistry.ALCHEMICAL_MERCURIES));
        this.makeRecipe(this.name((Item)ItemRegistry.CALORIC_FLUX_EMITTER.get()) + "_from_campfire", new RecipeBuilder((ItemLike)ItemRegistry.CALORIC_FLUX_EMITTER.get(), 1).pattern(" h ").pattern("gmg").pattern("sss").define('h', (ItemLike)Items.f_42781_).define('g', (TagKey<Item>)Tags.Items.INGOTS_GOLD).define('s', (TagKey<Item>)Tags.Items.STONE).define('m', ItemTagRegistry.ALCHEMICAL_MERCURIES));
        this.makeRecipe(this.name((Item)ItemRegistry.CALORIC_FLUX_EMITTER.get()) + "_from_lava_bucket", new RecipeBuilder((ItemLike)ItemRegistry.CALORIC_FLUX_EMITTER.get(), 1).pattern(" h ").pattern("gmg").pattern("sss").define('h', (ItemLike)Items.f_42448_).define('g', (TagKey<Item>)Tags.Items.INGOTS_GOLD).define('s', (TagKey<Item>)Tags.Items.STONE).define('m', ItemTagRegistry.ALCHEMICAL_MERCURIES));
        this.makeRecipe(this.name((Item)ItemRegistry.SULFURIC_FLUX_EMITTER.get()), new RecipeBuilder((ItemLike)ItemRegistry.SULFURIC_FLUX_EMITTER.get(), 1).pattern(" a ").pattern("gSg").pattern("sss").define('a', ItemTagRegistry.SAL_AMMONIAC_GEMS).define('g', (TagKey<Item>)Tags.Items.INGOTS_GOLD).define('s', (TagKey<Item>)Tags.Items.STONE).define('S', ItemTagRegistry.ALCHEMICAL_SULFURS));
        this.makeRecipe(this.name((Item)ItemRegistry.REFORMATION_TARGET_PEDESTAL.get()), new RecipeBuilder((ItemLike)ItemRegistry.REFORMATION_TARGET_PEDESTAL.get(), 1).pattern("cSc").pattern("cdc").pattern("sss").define('S', ItemTagRegistry.ALCHEMICAL_SULFURS).define('c', (TagKey<Item>)Tags.Items.INGOTS_COPPER).define('s', (ItemLike)Items.f_42755_).define('d', (TagKey<Item>)Tags.Items.GEMS_DIAMOND));
        this.makeRecipe(this.name((Item)ItemRegistry.REFORMATION_SOURCE_PEDESTAL.get()), new RecipeBuilder((ItemLike)ItemRegistry.REFORMATION_SOURCE_PEDESTAL.get(), 1).pattern("sSs").pattern("iii").pattern("sss").define('S', ItemTagRegistry.ALCHEMICAL_SULFURS).define('i', (TagKey<Item>)Tags.Items.INGOTS_IRON).define('s', (ItemLike)Items.f_42755_));
        this.makeRecipe(this.name((Item)ItemRegistry.REFORMATION_RESULT_PEDESTAL.get()), new RecipeBuilder((ItemLike)ItemRegistry.REFORMATION_RESULT_PEDESTAL.get(), 1).pattern("ggg").pattern("gSg").pattern("sss").define('S', ItemTagRegistry.ALCHEMICAL_SULFURS).define('g', (TagKey<Item>)Tags.Items.INGOTS_GOLD).define('s', (ItemLike)Items.f_42755_));
        this.makeRecipe(this.name((Item)ItemRegistry.FERMENTATION_VAT.get()), new RecipeBuilder((ItemLike)ItemRegistry.FERMENTATION_VAT.get(), 1).pattern("csc").pattern("cbc").pattern("cCc").define('s', ItemTagRegistry.ALCHEMICAL_SULFURS).define('b', (TagKey<Item>)Tags.Items.BARRELS_WOODEN).define('C', (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COPPER).define('c', (TagKey<Item>)Tags.Items.INGOTS_COPPER));
        this.makeRecipe(this.name((Item)ItemRegistry.DIGESTION_VAT.get()), new RecipeBuilder((ItemLike)ItemRegistry.DIGESTION_VAT.get(), 1).pattern(" s ").pattern("gpg").pattern("SSS").define('s', ItemTagRegistry.SAL_AMMONIAC_GEMS).define('p', (ItemLike)Items.f_271478_).define('g', (TagKey<Item>)Tags.Items.INGOTS_GOLD).define('S', (TagKey<Item>)Tags.Items.SANDSTONE));
    }

    public JsonObject makeDivinationRodSettings(DivinationRodItem rodItem) {
        return this.makeDivinationRodSettings(rodItem.defaultTier, rodItem.defaultAllowedBlocksTag, rodItem.defaultDisallowedBlocksTag, rodItem.defaultRange, rodItem.defaultDuration, rodItem.defaultDurability);
    }

    public JsonObject makeDivinationRodSettings(Tier defaultTier, TagKey<Block> defaultAllowedBlocksTag, TagKey<Block> defaultDisallowedBlocksTag, int defaultRange, int defaultDuration, int defaultDurability) {
        JsonObject settings = new JsonObject();
        settings.addProperty("theurgy:divination.setting.tier", TierSortingRegistry.getName((Tier)defaultTier).toString());
        settings.addProperty("theurgy:divination.setting.allowed_blocks_tag", defaultAllowedBlocksTag.f_203868_().toString());
        settings.addProperty("theurgy:divination.setting.disallowed_blocks_tag", defaultDisallowedBlocksTag.f_203868_().toString());
        settings.addProperty("theurgy:divination.setting.range", (Number)defaultRange);
        settings.addProperty("theurgy:divination.setting.duration", (Number)defaultDuration);
        settings.addProperty("theurgy:divination.setting.max_damage", (Number)defaultDurability);
        return settings;
    }

    public void makeRecipe(ItemLike result, RecipeBuilder recipe) {
        this.makeRecipe(this.name(result.m_5456_()), recipe);
    }

    public void makeRecipe(String name, RecipeBuilder recipe) {
        this.recipeConsumer.accept(this.modLoc(name), recipe.build());
    }

    public String m_6055_() {
        return "Shaped Crafting Recipes";
    }

    private class RecipeBuilder {
        private final JsonObject recipe = new JsonObject();

        public RecipeBuilder(ItemLike result) {
            this(result, 1);
        }

        public RecipeBuilder(ItemLike result, int count) {
            this(result, count, null);
        }

        public RecipeBuilder(ItemLike result, @Nullable int count, JsonObject nbt) {
            this(result, count, nbt, ForgeRegistries.RECIPE_SERIALIZERS.getKey((Object)RecipeSerializer.f_44076_).toString());
        }

        public RecipeBuilder(ItemLike result, @Nullable int count, JsonObject nbt, String recipeType) {
            this(shapedRecipeProvider.makeItemResult(shapedRecipeProvider.locFor(result), count, nbt), recipeType);
        }

        public RecipeBuilder(JsonObject result, String recipeType) {
            this.recipe.addProperty("type", recipeType);
            this.recipe.add("result", (JsonElement)result);
            this.recipe.add("key", (JsonElement)new JsonObject());
            this.recipe.add("pattern", (JsonElement)new JsonArray());
        }

        public RecipeBuilder define(char key, TagKey<Item> tag) {
            return this.define(key, ShapedRecipeProvider.this.makeTagIngredient(ShapedRecipeProvider.this.locFor(tag)));
        }

        public RecipeBuilder define(char key, ItemLike item) {
            return this.define(key, ShapedRecipeProvider.this.makeItemIngredient(ShapedRecipeProvider.this.locFor(item)));
        }

        public RecipeBuilder define(char key, JsonObject ingredient) {
            String keyString = String.valueOf(key);
            JsonObject keys = this.recipe.getAsJsonObject("key");
            if (keys.has(keyString)) {
                throw new IllegalArgumentException("Key " + keyString + " already defined");
            }
            keys.add(keyString, (JsonElement)ingredient);
            return this;
        }

        public RecipeBuilder pattern(String pattern) {
            this.recipe.getAsJsonArray("pattern").add(pattern);
            return this;
        }

        public JsonObject build() {
            return this.recipe;
        }
    }
}

