/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SaltRegistry;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

public class CalcinationRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 100;

    public CalcinationRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "calcination");
    }

    @Override
    void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.makeRecipe((Item)SaltRegistry.STRATA.get(), "from_stone", (TagKey<Item>)Tags.Items.STONE);
        this.makeRecipe((Item)SaltRegistry.STRATA.get(), "from_sandstone", (TagKey<Item>)Tags.Items.SANDSTONE);
        this.makeRecipe((Item)SaltRegistry.STRATA.get(), "from_cobblestone", (TagKey<Item>)Tags.Items.COBBLESTONE);
        this.makeRecipe((Item)SaltRegistry.STRATA.get(), "from_dirt", (TagKey<Item>)ItemTags.f_198160_);
        this.makeRecipe((Item)SaltRegistry.STRATA.get(), "from_sand", (TagKey<Item>)ItemTags.f_13137_);
        this.makeRecipe((Item)SaltRegistry.STRATA.get(), "from_gravel", 1, Items.f_41832_, 1, 100);
        this.makeRecipe((Item)SaltRegistry.STRATA.get(), "from_clay", 4, Items.f_41983_, 1, 100);
        this.makeRecipe((Item)SaltRegistry.STRATA.get(), "from_clay_ball", 1, Items.f_42461_, 1, 100);
        this.makeRecipe((Item)SaltRegistry.MINERAL.get(), "from_ores", (TagKey<Item>)Tags.Items.ORES);
        this.makeRecipe((Item)SaltRegistry.MINERAL.get(), "from_raw_materials", (TagKey<Item>)Tags.Items.RAW_MATERIALS);
        this.makeRecipe((Item)SaltRegistry.MINERAL.get(), "from_ingots", 2, (TagKey<Item>)Tags.Items.INGOTS);
        this.makeRecipe((Item)SaltRegistry.MINERAL.get(), "from_gems", 2, (TagKey<Item>)Tags.Items.GEMS);
        this.makeRecipe((Item)SaltRegistry.MINERAL.get(), "from_other_minerals", 2, ItemTagRegistry.OTHER_MINERALS);
        this.makeRecipe((Item)SaltRegistry.CROPS.get(), "", (TagKey<Item>)Tags.Items.CROPS);
        this.makeRecipe((Item)SaltRegistry.MINERAL.get(), "", 1, (Item)SaltRegistry.STRATA.get(), 20, 100);
    }

    public void makeRecipe(Item salt, String suffix, TagKey<Item> ingredient) {
        this.makeRecipe(salt, suffix, ingredient, 100);
    }

    public void makeRecipe(Item salt, String suffix, TagKey<Item> ingredient, int calcinationTime) {
        this.makeRecipe(salt, suffix, 1, ingredient, 1, calcinationTime);
    }

    public void makeRecipe(Item salt, String suffix, int resultCount, TagKey<Item> ingredient) {
        this.makeRecipe(salt, suffix, resultCount, ingredient, 1);
    }

    public void makeRecipe(Item salt, String suffix, int resultCount, TagKey<Item> ingredient, int ingredientCount) {
        this.makeRecipe(salt, suffix, resultCount, ingredient, ingredientCount, 100);
    }

    public void makeRecipe(Item salt, String suffix, int resultCount, Item ingredient, int ingredientCount, int calcinationTime) {
        Object name = this.name(salt).replace("alchemical_salt_", "");
        if (suffix != null && !suffix.isEmpty()) {
            name = (String)name + "_" + suffix;
        }
        JsonObject recipe = this.makeRecipeJson(this.makeItemIngredient(this.locFor((ItemLike)ingredient)), ingredientCount, this.makeItemResult(this.locFor((ItemLike)salt), resultCount), calcinationTime);
        this.recipeConsumer.accept(this.modLoc((String)name), recipe);
    }

    public void makeRecipe(Item salt, String suffix, int resultCount, TagKey<Item> ingredient, int ingredientCount, int calcinationTime) {
        Object name = this.name(salt).replace("alchemical_salt_", "");
        if (suffix != null && !suffix.isEmpty()) {
            name = (String)name + "_" + suffix;
        }
        JsonObject recipe = this.makeRecipeJson(this.makeTagIngredient(this.locFor(ingredient)), ingredientCount, this.makeItemResult(this.locFor((ItemLike)salt), resultCount), calcinationTime);
        JsonArray conditions = new JsonArray();
        conditions.add((JsonElement)this.makeTagNotEmptyCondition(ingredient.f_203868_().toString()));
        recipe.add("conditions", (JsonElement)conditions);
        this.recipeConsumer.accept(this.modLoc((String)name), recipe);
    }

    public JsonObject makeRecipeJson(JsonObject ingredient, int ingredientCount, JsonObject result, int calcinationTime) {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", RecipeTypeRegistry.CALCINATION.getId().toString());
        recipe.add("ingredient", (JsonElement)ingredient);
        recipe.addProperty("ingredient_count", (Number)ingredientCount);
        recipe.add("result", (JsonElement)result);
        recipe.addProperty("calcination_time", (Number)calcinationTime);
        return recipe;
    }

    public String m_6055_() {
        return "Calcination Recipes";
    }
}

