/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.klikli_dev.theurgy.content.recipe.wrapper.ReformationArrayRecipeWrapper;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.RecipeSerializerRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.util.TheurgyExtraCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ReformationRecipe
implements Recipe<ReformationArrayRecipeWrapper> {
    public static final int DEFAULT_REFORMATION_TIME = 100;
    public static final Codec<ReformationRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TheurgyExtraCodecs.INGREDIENT.listOf().fieldOf("sources").forGetter(r -> r.sources), (App)TheurgyExtraCodecs.INGREDIENT.fieldOf("target").forGetter(r -> r.target), (App)ItemStack.f_41582_.fieldOf("result").forGetter(r -> r.result), (App)Codec.INT.fieldOf("mercury_flux").forGetter(r -> r.mercuryFlux), (App)Codec.INT.optionalFieldOf("reformation_time", (Object)100).forGetter(r -> r.reformationTime)).apply((Applicative)instance, ReformationRecipe::new));
    protected final List<Ingredient> sources;
    protected final Ingredient target;
    protected final ItemStack result;
    protected final int mercuryFlux;
    protected final int reformationTime;
    protected ResourceLocation id;

    public ReformationRecipe(List<Ingredient> sources, Ingredient target, ItemStack result, int mercuryFlux, int reformationTime) {
        this.sources = sources;
        this.target = target;
        this.result = result;
        this.mercuryFlux = mercuryFlux;
        this.reformationTime = reformationTime;
    }

    public List<Ingredient> getSources() {
        return this.sources;
    }

    public Ingredient getTarget() {
        return this.target;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getMercuryFlux() {
        return this.mercuryFlux;
    }

    public int getReformationTime() {
        return this.reformationTime;
    }

    public boolean matches(ReformationArrayRecipeWrapper pContainer, Level pLevel) {
        if (pContainer.getMercuryFluxStorage().getEnergyStored() < this.mercuryFlux) {
            return false;
        }
        if (!this.target.test(pContainer.getTargetPedestalInv().getStackInSlot(0))) {
            return false;
        }
        ArrayList<Ingredient> remainingSources = new ArrayList<Ingredient>(this.sources);
        List<ItemStack> pedestalsToCheck = pContainer.getSourcePedestalInvs().stream().map(p -> p.getStackInSlot(0).m_41777_()).toList();
        for (Ingredient source : remainingSources) {
            boolean found = false;
            for (ItemStack sourceInputStack : pedestalsToCheck) {
                if (!source.test(sourceInputStack)) continue;
                sourceInputStack.m_41764_(0);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(ReformationArrayRecipeWrapper pContainer, RegistryAccess pRegistryAccess) {
        ItemStack result = this.result.m_41777_();
        ItemStack targetItem = pContainer.getTargetPedestalInv().getStackInSlot(0);
        if (targetItem.m_41782_()) {
            result.m_41751_(targetItem.m_41783_().m_6426_());
        }
        return result;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.addAll(this.sources);
        return nonnulllist;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)BlockRegistry.REFORMATION_RESULT_PEDESTAL.get());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.REFORMATION.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.REFORMATION.get();
    }

    public static class Serializer
    implements RecipeSerializer<ReformationRecipe> {
        public ReformationRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            ReformationRecipe recipe = (ReformationRecipe)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)pJson).getOrThrow(false, s -> {
                throw new JsonParseException(s);
            });
            recipe.id = pRecipeId;
            return recipe;
        }

        public ReformationRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            ReformationRecipe recipe = (ReformationRecipe)pBuffer.m_271872_(CODEC);
            recipe.id = pRecipeId;
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf pBuffer, ReformationRecipe pRecipe) {
            pBuffer.m_272073_(CODEC, (Object)pRecipe);
        }
    }

    public record IngedientWithCount(Ingredient ingredient, int count) {
        public static final Codec<IngedientWithCount> CODEC = Codec.pair((Codec)Codec.INT.optionalFieldOf("count", (Object)1).codec(), TheurgyExtraCodecs.INGREDIENT).xmap(s -> new IngedientWithCount((Ingredient)s.getSecond(), (Integer)s.getFirst()), s -> Pair.of((Object)s.count, (Object)s.ingredient));
    }
}

