/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.klikli_dev.theurgy.content.recipe.ingredient.FluidIngredient;
import com.klikli_dev.theurgy.content.recipe.wrapper.RecipeWrapperWithFluid;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.RecipeSerializerRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.util.TheurgyExtraCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class AccumulationRecipe
implements Recipe<RecipeWrapperWithFluid> {
    public static final int DEFAULT_ACCUMULATION_TIME = 100;
    public static final Codec<AccumulationRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FluidIngredient.CODEC.fieldOf("evaporant").forGetter(r -> r.evaporant), (App)Codec.INT.fieldOf("evaporantAmount").forGetter(r -> r.evaporantAmount), (App)TheurgyExtraCodecs.INGREDIENT.optionalFieldOf("solute").forGetter(r -> Optional.ofNullable(r.solute)), (App)FluidStack.CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.INT.optionalFieldOf("accumulationTime", (Object)100).forGetter(r -> r.accumulationTime)).apply((Applicative)instance, (evaporant, evaporantAmount, solute, result, accumulation_time) -> new AccumulationRecipe((FluidIngredient)((Object)((Object)evaporant)), (int)evaporantAmount, solute.orElse(null), (FluidStack)result, (int)accumulation_time)));
    protected final FluidIngredient evaporant;
    protected final int evaporantAmount;
    @Nullable
    protected final Ingredient solute;
    protected final FluidStack result;
    protected final int accumulationTime;
    protected ResourceLocation id;

    public AccumulationRecipe(FluidIngredient evaporant, int evaporantAmount, @Nullable Ingredient solute, FluidStack result, int pAccumulationTime) {
        this.evaporant = evaporant;
        this.evaporantAmount = evaporantAmount;
        this.solute = solute;
        this.result = result;
        this.accumulationTime = pAccumulationTime;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.ACCUMULATION.get();
    }

    public boolean matches(RecipeWrapperWithFluid pContainer, Level pLevel) {
        FluidStack fluid = pContainer.getTank().getFluidInTank(0);
        boolean evaporantMatches = this.evaporant.test(fluid) && fluid.getAmount() >= this.evaporantAmount;
        boolean soluteMatches = pContainer.m_8020_(0).m_41619_() && !this.hasSolute() || this.hasSolute() && this.solute.test(pContainer.m_8020_(0));
        return soluteMatches && evaporantMatches;
    }

    public ItemStack assemble(RecipeWrapperWithFluid pInv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public FluidStack assembleFluid(RecipeWrapperWithFluid pInv, RegistryAccess registryAccess) {
        return this.result.copy();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        if (this.solute != null) {
            nonnulllist.add((Object)this.solute);
        }
        return nonnulllist;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ItemRegistry.SAL_AMMONIAC_ACCUMULATOR.get());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.ACCUMULATION.get();
    }

    public int getAccumulationTime() {
        return this.accumulationTime;
    }

    public FluidIngredient getEvaporant() {
        return this.evaporant;
    }

    public int getEvaporantAmount() {
        return this.evaporantAmount;
    }

    @Nullable
    public Ingredient getSolute() {
        return this.solute;
    }

    public boolean hasSolute() {
        return this.solute != null;
    }

    public FluidStack getResult() {
        return this.result;
    }

    public static class Serializer
    implements RecipeSerializer<AccumulationRecipe> {
        public AccumulationRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            AccumulationRecipe recipe = (AccumulationRecipe)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)pJson).getOrThrow(false, s -> {
                throw new JsonParseException(s);
            });
            recipe.id = pRecipeId;
            return recipe;
        }

        public AccumulationRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            AccumulationRecipe recipe = (AccumulationRecipe)pBuffer.m_271872_(CODEC);
            recipe.id = pRecipeId;
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf pBuffer, AccumulationRecipe pRecipe) {
            pBuffer.m_272073_(CODEC, (Object)pRecipe);
        }
    }
}

