/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.salammoniactank.render;

import com.klikli_dev.theurgy.content.apparatus.salammoniactank.SalAmmoniacTankBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.salammoniactank.render.SalAmmoniacTankModel;
import com.klikli_dev.theurgy.content.render.FluidRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraftforge.fluids.FluidStack;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class SalAmmoniacTankRenderer
extends GeoBlockRenderer<SalAmmoniacTankBlockEntity> {
    public SalAmmoniacTankRenderer(BlockEntityRendererProvider.Context pContext) {
        super((GeoModel)new SalAmmoniacTankModel());
    }

    public void postRender(PoseStack poseStack, SalAmmoniacTankBlockEntity pBlockEntity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (pBlockEntity.tank.isEmpty()) {
            return;
        }
        FluidStack fluidStack = pBlockEntity.tank.getFluid();
        float fluidHeight = (float)fluidStack.getAmount() / (float)pBlockEntity.tank.getCapacity();
        float blockHeight = 0.921875f;
        float blockWidth = 1.0f;
        float capHeight = 0.25f;
        float tankHullWidth = 0.140625f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = blockHeight - 2.0f * capHeight - minPuddleHeight;
        float level = fluidHeight;
        float clampedLevel = Mth.m_14036_((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        float xMin = tankHullWidth;
        float xMax = xMin + blockWidth - 2.0f * tankHullWidth;
        float yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
        float yMax = yMin + clampedLevel;
        float zMin = tankHullWidth;
        float zMax = zMin + blockWidth - 2.0f * tankHullWidth;
        poseStack.m_85836_();
        poseStack.m_252880_(-0.5f, 0.0f, -0.5f);
        poseStack.m_252880_(0.0f, clampedLevel - totalHeight, 0.0f);
        FluidRenderer.renderFluidBox(fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, bufferSource, poseStack, packedLight, false);
        poseStack.m_85849_();
    }
}

