/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.reformationarray;

import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterSelectedPoint;
import com.klikli_dev.theurgy.content.behaviour.selection.SelectionBehaviour;
import com.klikli_dev.theurgy.network.Networking;
import com.klikli_dev.theurgy.network.messages.MessageSulfuricFluxEmitterSelection;
import com.klikli_dev.theurgy.registry.BlockTagRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class SulfuricFluxEmitterSelectionBehaviour
extends SelectionBehaviour<SulfuricFluxEmitterSelectedPoint> {
    @Override
    protected void displaySummary(BlockPos pos, Player player) {
        if (this.selectedPoints.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_selection").m_130940_(ChatFormatting.RED), true);
        } else {
            long sources = this.selectedPoints.stream().filter(s -> s.getType() == SulfuricFluxEmitterSelectedPoint.Type.SOURCE).count();
            long targets = this.selectedPoints.stream().filter(s -> s.getType() == SulfuricFluxEmitterSelectedPoint.Type.TARGET).count();
            long results = this.selectedPoints.stream().filter(s -> s.getType() == SulfuricFluxEmitterSelectedPoint.Type.RESULT).count();
            if (targets == 0L) {
                player.m_5661_((Component)Component.m_237115_((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_target").m_130940_(ChatFormatting.RED), true);
            }
            if (sources == 0L) {
                player.m_5661_((Component)Component.m_237115_((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_sources").m_130940_(ChatFormatting.RED), true);
            }
            if (results == 0L) {
                player.m_5661_((Component)Component.m_237115_((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_result").m_130940_(ChatFormatting.RED), true);
            }
            if (sources > 0L && targets > 0L && results > 0L) {
                player.m_5661_((Component)Component.m_237110_((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(sources)).m_130940_(ChatFormatting.DARK_PURPLE), Component.m_237113_((String)String.valueOf(targets)).m_130940_(ChatFormatting.BLUE), Component.m_237113_((String)String.valueOf(results)).m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.WHITE), true);
            }
        }
    }

    @Override
    protected void sendPlacementPacket(BlockPos pos) {
        List<SulfuricFluxEmitterSelectedPoint> sources = this.selectedPoints.stream().filter(s -> s.getType() == SulfuricFluxEmitterSelectedPoint.Type.SOURCE).toList();
        SulfuricFluxEmitterSelectedPoint target = this.selectedPoints.stream().filter(s -> s.getType() == SulfuricFluxEmitterSelectedPoint.Type.TARGET).findFirst().orElse(null);
        SulfuricFluxEmitterSelectedPoint result = this.selectedPoints.stream().filter(s -> s.getType() == SulfuricFluxEmitterSelectedPoint.Type.RESULT).findFirst().orElse(null);
        Networking.sendToServer(new MessageSulfuricFluxEmitterSelection(pos, sources, target, result));
    }

    @Override
    public int getBlockRange() {
        return 16;
    }

    @Override
    public boolean canCreate(Level level, BlockPos pos, BlockState state) {
        if (!level.m_46749_(pos)) {
            return false;
        }
        return state.m_204336_(BlockTagRegistry.REFORMATION_PEDESTALS);
    }

    @Override
    protected SulfuricFluxEmitterSelectedPoint create(Level level, BlockPos pos, BlockState state) {
        if (!this.canCreate(level, pos, state)) {
            return null;
        }
        SulfuricFluxEmitterSelectedPoint.Type type = this.getType(state);
        this.makeSpaceForNewSelection(type);
        return new SulfuricFluxEmitterSelectedPoint(level, pos, state, type);
    }

    private void makeSpaceForNewSelection(SulfuricFluxEmitterSelectedPoint.Type type) {
        if (type != SulfuricFluxEmitterSelectedPoint.Type.SOURCE) {
            if (type == SulfuricFluxEmitterSelectedPoint.Type.TARGET) {
                this.selectedPoints.removeIf(point -> point.getType() == SulfuricFluxEmitterSelectedPoint.Type.TARGET);
            } else {
                this.selectedPoints.removeIf(point -> point.getType() == SulfuricFluxEmitterSelectedPoint.Type.RESULT);
            }
        }
    }

    private SulfuricFluxEmitterSelectedPoint.Type getType(BlockState state) {
        if (state.m_204336_(BlockTagRegistry.REFORMATION_SOURCE_PEDESTALS)) {
            return SulfuricFluxEmitterSelectedPoint.Type.SOURCE;
        }
        if (state.m_204336_(BlockTagRegistry.REFORMATION_TARGET_PEDESTALS)) {
            return SulfuricFluxEmitterSelectedPoint.Type.TARGET;
        }
        return SulfuricFluxEmitterSelectedPoint.Type.RESULT;
    }

    @Override
    protected boolean isSelectionItem(ItemStack stack) {
        return stack.m_150930_((Item)ItemRegistry.SULFURIC_FLUX_EMITTER.get());
    }
}

