/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.reformationarray;

import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterBlockEntity;
import com.klikli_dev.theurgy.content.particle.ParticleColor;
import com.klikli_dev.theurgy.content.particle.glow.GlowParticleProvider;
import com.klikli_dev.theurgy.content.storage.MonitoredItemStackHandler;
import com.klikli_dev.theurgy.content.storage.PreventInsertWrapper;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformationResultPedestalBlockEntity
extends BlockEntity {
    public ItemStackHandler outputInventory = new OutputInventory();
    public PreventInsertWrapper outputInventoryTakeOnlyWrapper = new PreventInsertWrapper((IItemHandlerModifiable)this.outputInventory);
    public LazyOptional<IItemHandler> outputInventoryCapability = LazyOptional.of(() -> this.outputInventoryTakeOnlyWrapper);
    public WeakReference<SulfuricFluxEmitterBlockEntity> sulfuricFluxEmitter;
    protected boolean showParticles;

    public ReformationResultPedestalBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.REFORMATION_RESULT_PEDESTAL.get(), pPos, pBlockState);
    }

    public void setSulfuricFluxEmitter(SulfuricFluxEmitterBlockEntity sulfuricFluxEmitter) {
        this.sulfuricFluxEmitter = new WeakReference<SulfuricFluxEmitterBlockEntity>(sulfuricFluxEmitter);
    }

    public void tickClient() {
        if (this.showParticles && this.f_58857_.m_213780_().m_188501_() < 0.07f) {
            BlockPos pos = this.m_58899_();
            this.f_58857_.m_7106_(GlowParticleProvider.createOptions(ParticleColor.fromInt(32768), 0.5f, 0.75f, 200), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.0f), (double)((float)pos.m_123343_() + 0.5f), 0.0, 0.0, 0.0);
        }
    }

    public void m_7651_() {
        if (this.sulfuricFluxEmitter != null && this.sulfuricFluxEmitter.get() != null) {
            ((SulfuricFluxEmitterBlockEntity)((Object)this.sulfuricFluxEmitter.get())).removeResultPedestal(this);
            this.sulfuricFluxEmitter.clear();
        }
        super.m_7651_();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.writeNetwork(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.readNetwork(pTag);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.outputInventoryCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.outputInventoryCapability.invalidate();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.writeNetwork(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readNetwork(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.readNetwork(tag);
        }
    }

    public void readNetwork(CompoundTag pTag) {
        if (pTag.m_128441_("showParticles")) {
            this.showParticles = pTag.m_128471_("showParticles");
        }
        if (pTag.m_128441_("outputInventory")) {
            this.outputInventory.deserializeNBT(pTag.m_128469_("outputInventory"));
        }
    }

    public void writeNetwork(CompoundTag pTag) {
        this.showParticles = !this.outputInventory.getStackInSlot(0).m_41619_();
        pTag.m_128379_("showParticles", this.showParticles);
        pTag.m_128365_("outputInventory", (Tag)this.outputInventory.serializeNBT());
    }

    public void sendBlockUpdated() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public class OutputInventory
    extends MonitoredItemStackHandler {
        public OutputInventory() {
            super(1);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            ReformationResultPedestalBlockEntity.this.sendBlockUpdated();
        }

        protected void onContentsChanged(int slot) {
            ReformationResultPedestalBlockEntity.this.m_6596_();
        }
    }
}

