/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.mercurycatalyst;

import com.klikli_dev.theurgy.content.apparatus.mercurycatalyst.MercuryCatalystBlockEntity;
import com.klikli_dev.theurgy.content.behaviour.itemhandler.ItemHandlerBehaviour;
import com.klikli_dev.theurgy.content.behaviour.itemhandler.OneSlotItemHandlerBehaviour;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class MercuryCatalystBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    protected ItemHandlerBehaviour itemHandlerBehaviour = new OneSlotItemHandlerBehaviour();

    public MercuryCatalystBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    public static int getBlockColor(BlockState pState, BlockAndTintGetter pLevel, BlockPos pPos, int pTintIndex) {
        BlockEntity blockEntity;
        if (pTintIndex != 0 && pLevel != null && pPos != null && (blockEntity = pLevel.m_7702_(pPos)) instanceof MercuryCatalystBlockEntity) {
            MercuryCatalystBlockEntity blockEntity2 = (MercuryCatalystBlockEntity)blockEntity;
            float fillLevel = (float)blockEntity2.mercuryFluxStorage.getEnergyStored() / (float)blockEntity2.mercuryFluxStorage.getMaxEnergyStored();
            return MercuryCatalystBlock.getColorFromFillLevel(fillLevel);
        }
        return 0xFFFFFF;
    }

    public static int getItemColor(ItemStack pStack, int pTintIndex) {
        if (pStack.m_41782_() && pStack.m_41783_().m_128441_("BlockEntityTag")) {
            float fillLevel = (float)pStack.m_41783_().m_128469_("BlockEntityTag").m_128451_("mercuryFluxStorage") / 50000.0f;
            return MercuryCatalystBlock.getColorFromFillLevel(fillLevel);
        }
        return 0xFFFFFF;
    }

    public static int getColorFromFillLevel(float fillLevel) {
        int r = (int)((double)(1.0f - fillLevel) * 255.0);
        int g = (int)((double)(1.0f - fillLevel) * 255.0);
        int b = 255;
        r = Math.max(0, Math.min(255, r));
        g = Math.max(0, Math.min(255, g));
        b = Math.max(0, Math.min(255, b));
        int rgb = r << 16 | g << 8 | b;
        return rgb;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (this.itemHandlerBehaviour.useItemHandler(pState, pLevel, pPos, pPlayer, pHand, pHit) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        super.m_6861_(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        this.checkPoweredState(pLevel, pPos, pState, 4);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.m_60713_(pState.m_60734_())) {
            this.checkPoweredState(pLevel, pPos, pState, 2);
        }
    }

    private void checkPoweredState(Level pLevel, BlockPos pPos, BlockState pState, int pFlags) {
        boolean enabled;
        boolean bl = enabled = !pLevel.m_276867_(pPos);
        if (enabled != (Boolean)pState.m_61143_((Property)ENABLED)) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(enabled)), pFlags);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{ENABLED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)BlockEntityRegistry.MERCURY_CATALYST.get()).m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof MercuryCatalystBlockEntity) {
                MercuryCatalystBlockEntity blockEntity = (MercuryCatalystBlockEntity)t;
                blockEntity.tickServer();
            }
        };
    }
}

