/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.fermentationvat;

import com.klikli_dev.theurgy.content.apparatus.fermentationvat.FermentationCraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.StorageBehaviour;
import com.klikli_dev.theurgy.content.storage.MonitoredFluidTank;
import com.klikli_dev.theurgy.content.storage.MonitoredItemStackHandler;
import com.klikli_dev.theurgy.content.storage.PreventInsertExtractFluidWrapper;
import com.klikli_dev.theurgy.content.storage.PreventInsertExtractWrapper;
import com.klikli_dev.theurgy.content.storage.PreventInsertWrapper;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FermentationStorageBehaviour
extends StorageBehaviour<FermentationStorageBehaviour> {
    public ItemStackHandler inputInventory;
    public LazyOptional<IItemHandler> inputInventoryCapability;
    public LazyOptional<IItemHandler> inputInventoryReadOnlyCapability;
    public ItemStackHandler outputInventory;
    public LazyOptional<IItemHandler> outputInventoryExtractOnlyCapability;
    public LazyOptional<IItemHandler> outputInventoryReadOnlyCapability;
    public CombinedInvWrapper inventory;
    public LazyOptional<IItemHandler> inventoryCapability;
    public LazyOptional<IItemHandler> inventoryReadOnlyCapability;
    public FluidTank fluidTank;
    public LazyOptional<IFluidHandler> fluidTankCapability;
    public LazyOptional<IFluidHandler> fluidTankReadOnlyCapability;
    public Supplier<FermentationCraftingBehaviour> craftingBehaviour;

    public FermentationStorageBehaviour(BlockEntity blockEntity, Supplier<FermentationCraftingBehaviour> craftingBehaviour) {
        super(blockEntity);
        this.craftingBehaviour = craftingBehaviour;
        this.inputInventory = new InputInventory();
        this.inputInventoryCapability = LazyOptional.of(() -> this.inputInventory);
        this.inputInventoryReadOnlyCapability = LazyOptional.of(() -> new PreventInsertExtractWrapper((IItemHandlerModifiable)this.inputInventory));
        this.outputInventory = new OutputInventory();
        PreventInsertWrapper outputInventoryTakeOnlyWrapper = new PreventInsertWrapper((IItemHandlerModifiable)this.outputInventory);
        this.outputInventoryExtractOnlyCapability = LazyOptional.of(() -> outputInventoryTakeOnlyWrapper);
        this.outputInventoryReadOnlyCapability = LazyOptional.of(() -> new PreventInsertExtractWrapper((IItemHandlerModifiable)this.outputInventory));
        this.inventory = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, outputInventoryTakeOnlyWrapper});
        this.inventoryCapability = LazyOptional.of(() -> this.inventory);
        this.inventoryReadOnlyCapability = LazyOptional.of(() -> new PreventInsertExtractWrapper((IItemHandlerModifiable)this.inventory));
        this.fluidTank = new WaterTank(10000, f -> this.craftingBehaviour.get().canProcess((FluidStack)f));
        this.fluidTankCapability = LazyOptional.of(() -> this.fluidTank);
        this.fluidTankReadOnlyCapability = LazyOptional.of(() -> new PreventInsertExtractFluidWrapper((IFluidHandler)this.fluidTank));
        this.register(this.inventoryCapability);
        this.register(this.inputInventoryCapability);
        this.register(this.inventoryReadOnlyCapability);
        this.register(this.fluidTankCapability);
        this.register(this.fluidTankReadOnlyCapability);
        this.register(this.outputInventoryExtractOnlyCapability);
        this.register(this.outputInventoryReadOnlyCapability);
    }

    @Override
    public void readNetwork(CompoundTag pTag) {
        if (pTag.m_128441_("inputInventory")) {
            this.inputInventory.deserializeNBT(pTag.m_128469_("inputInventory"));
        }
        if (pTag.m_128441_("outputInventory")) {
            this.outputInventory.deserializeNBT(pTag.m_128469_("outputInventory"));
        }
        if (pTag.m_128441_("fluidTank")) {
            this.fluidTank.readFromNBT(pTag.m_128469_("fluidTank"));
        }
    }

    @Override
    public void writeNetwork(CompoundTag pTag) {
        pTag.m_128365_("inputInventory", (Tag)this.inputInventory.serializeNBT());
        pTag.m_128365_("outputInventory", (Tag)this.outputInventory.serializeNBT());
        pTag.m_128365_("fluidTank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
    }

    @Override
    public void saveAdditional(CompoundTag pTag) {
        this.writeNetwork(pTag);
    }

    @Override
    public void load(CompoundTag pTag) {
        this.readNetwork(pTag);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Boolean isOpen = (Boolean)this.blockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61446_);
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.UP) {
                return isOpen != false ? this.inputInventoryCapability.cast() : this.inputInventoryReadOnlyCapability.cast();
            }
            if (side == Direction.DOWN) {
                return isOpen != false ? this.outputInventoryExtractOnlyCapability.cast() : this.outputInventoryReadOnlyCapability.cast();
            }
            return isOpen != false ? this.inventoryCapability.cast() : this.inventoryReadOnlyCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return isOpen != false ? this.fluidTankCapability.cast() : this.fluidTankReadOnlyCapability.cast();
        }
        return LazyOptional.empty();
    }

    public class InputInventory
    extends MonitoredItemStackHandler {
        public InputInventory() {
            super(3);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            FermentationStorageBehaviour.this.craftingBehaviour.get().onInputItemChanged(oldStack, newStack);
            FermentationStorageBehaviour.this.sendBlockUpdated();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            for (int i = 0; i < this.getSlots(); ++i) {
                if (i == slot || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.getStackInSlot(i))) continue;
                return false;
            }
            return FermentationStorageBehaviour.this.craftingBehaviour.get().canProcess(stack) && super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            FermentationStorageBehaviour.this.setChanged();
        }
    }

    public class OutputInventory
    extends MonitoredItemStackHandler {
        public OutputInventory() {
            super(1);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            FermentationStorageBehaviour.this.sendBlockUpdated();
        }

        protected void onContentsChanged(int slot) {
            FermentationStorageBehaviour.this.setChanged();
        }
    }

    public class WaterTank
    extends MonitoredFluidTank {
        public WaterTank(int capacity, Predicate<FluidStack> validator) {
            super(capacity, validator);
        }

        protected void onContentsChanged() {
            FermentationStorageBehaviour.this.setChanged();
        }

        @Override
        protected void onContentTypeChanged(FluidStack oldStack, FluidStack newStack) {
            FermentationStorageBehaviour.this.sendBlockUpdated();
        }
    }
}

