/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.digestionvat;

import com.klikli_dev.theurgy.content.apparatus.digestionvat.DigestionVatBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.digestionvat.DigestionVatInteractionBehaviour;
import com.klikli_dev.theurgy.content.behaviour.CraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.HasCraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.fluidhandler.FluidHandlerBehaviour;
import com.klikli_dev.theurgy.content.behaviour.fluidhandler.OneTankFluidHandlerBehaviour;
import com.klikli_dev.theurgy.content.behaviour.interaction.InteractionBehaviour;
import com.klikli_dev.theurgy.content.behaviour.itemhandler.DynamicOneOutputSlotItemHandlerBehaviour;
import com.klikli_dev.theurgy.content.behaviour.itemhandler.ItemHandlerBehaviour;
import com.klikli_dev.theurgy.content.recipe.DigestionRecipe;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;

public class DigestionVatBlock
extends Block
implements EntityBlock {
    private static final VoxelShape BOUNDING_BOX = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    protected ItemHandlerBehaviour itemHandlerBehaviour = new DynamicOneOutputSlotItemHandlerBehaviour();
    protected FluidHandlerBehaviour fluidHandlerBehaviour = new OneTankFluidHandlerBehaviour();
    protected InteractionBehaviour interactionBehaviour = new DigestionVatInteractionBehaviour();

    public DigestionVatBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        InteractionResult interactionResult = this.interactionBehaviour.use(pState, pLevel, pPos, pPlayer, pHand, pHit);
        if (interactionResult != InteractionResult.PASS) {
            return interactionResult;
        }
        if (this.fluidHandlerBehaviour.useFluidHandler(pState, pLevel, pPos, pPlayer, pHand, pHit) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (this.itemHandlerBehaviour.useItemHandler(pState, pLevel, pPos, pPlayer, pHand, pHit) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        boolean hasSignal = pLevel.m_276867_(pPos);
        boolean wasOpen = (Boolean)pState.m_61143_((Property)OPEN);
        if (hasSignal && wasOpen) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (!(blockEntity instanceof HasCraftingBehaviour)) {
                return;
            }
            HasCraftingBehaviour vat = (HasCraftingBehaviour)blockEntity;
            CraftingBehaviour craftingBehaviour = vat.craftingBehaviour();
            Optional recipe = craftingBehaviour.getRecipe();
            if (recipe.isPresent() && craftingBehaviour.canCraft((DigestionRecipe)recipe.get())) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)), 2);
            }
        } else if (!hasSignal && !wasOpen) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (!pState.m_60713_(pNewState.m_60734_()) && (blockEntity = pLevel.m_7702_(pPos)) instanceof DigestionVatBlockEntity) {
            DigestionVatBlockEntity blockEntity2 = (DigestionVatBlockEntity)blockEntity;
            Containers.m_19002_((Level)pLevel, (BlockPos)pPos, (Container)new RecipeWrapper((IItemHandlerModifiable)blockEntity2.storageBehaviour.inventory));
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return BOUNDING_BOX;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)pContext.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HORIZONTAL_FACING, OPEN});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)BlockEntityRegistry.DIGESTION_VAT.get()).m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof DigestionVatBlockEntity) {
                DigestionVatBlockEntity blockEntity = (DigestionVatBlockEntity)t;
                blockEntity.tickServer();
            }
        };
    }
}

