/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.common.item;

import cofh.core.common.capability.CapabilityAreaEffect;
import cofh.core.common.item.IMultiModeItem;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.AreaEffectHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.lib.api.capability.IAreaEffectItem;
import cofh.lib.api.item.IEnergyContainerItem;
import cofh.lib.common.energy.EnergyContainerItemWrapper;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.lib.common.item.EnergyContainerItemAugmentable;
import cofh.thermal.lib.common.item.IFlexibleEnergyContainerItem;
import cofh.thermal.lib.util.ThermalAugmentRules;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class RFPumpItem
extends EnergyContainerItemAugmentable
implements IMultiModeItem,
IFlexibleEnergyContainerItem {
    public static final int ENERGY_PER_USE = 200;

    public RFPumpItem(Item.Properties builder, int maxEnergy, int maxTransfer) {
        super(builder, maxEnergy, maxTransfer);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), (stack, world, entity, seed) -> this.getEnergyStored(stack) > 0 ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("active"), (stack, world, entity, seed) -> this.getEnergyStored(stack) > 0 && this.hasActiveTag(stack) ? 1.0f : 0.0f);
        this.numSlots = () -> ThermalCoreConfig.toolAugments;
        this.augValidator = ThermalAugmentRules.createAllowValidator((String[])new String[]{"Upgrade", "RF", "Area", "Filter"});
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        int radius = this.getMode(stack) * 2 + 1;
        if (radius <= 1) {
            tooltip.add((Component)Component.m_237115_((String)"info.cofh.single_block").m_130940_(ChatFormatting.ITALIC));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"info.cofh.area").m_130946_(": " + radius + "x" + radius).m_130940_(ChatFormatting.ITALIC));
        }
        if (this.getNumModes(stack) > 1) {
            this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        }
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.hasActiveTag(stack)) {
            return;
        }
        long activeTime = stack.m_41784_().m_128454_("Active");
        if (entityIn.f_19853_.m_46467_() > activeTime) {
            stack.m_41784_().m_128473_("Active");
        }
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundTag augmentData) {
        CompoundTag subTag = container.m_41737_("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundTag)subTag, (CompoundTag)augmentData, (String)"Radius");
        super.setAttributesFromAugment(container, augmentData);
    }

    protected int getEnergyPerUse(ItemStack stack) {
        return 200;
    }

    protected int getRadius(ItemStack stack) {
        return (int)AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"Radius", (float)0.0f);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new RFPumpItemWrapper(stack, (IEnergyContainerItem)this);
    }

    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        super.updateAugmentState(container, augments);
        if (this.getMode(container) >= this.getNumModes(container)) {
            this.setMode(container, this.getNumModes(container) - 1);
        }
    }

    public int getNumModes(ItemStack stack) {
        return 1 + this.getRadius(stack);
    }

    public void onModeChange(Player player, ItemStack stack) {
        player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_12088_, SoundSource.PLAYERS, 0.4f, 1.0f - 0.1f * (float)this.getMode(stack));
        int radius = this.getMode(stack) * 2 + 1;
        if (radius <= 1) {
            ProxyUtils.setOverlayMessage((Player)player, (Component)Component.m_237115_((String)"info.cofh.single_block"));
        } else {
            ProxyUtils.setOverlayMessage((Player)player, (Component)Component.m_237115_((String)"info.cofh.area").m_130946_(": " + radius + "x" + radius));
        }
    }

    protected class RFPumpItemWrapper
    extends EnergyContainerItemWrapper
    implements IAreaEffectItem {
        private final LazyOptional<IAreaEffectItem> holder;

        RFPumpItemWrapper(ItemStack containerIn, IEnergyContainerItem itemIn) {
            super(containerIn, itemIn, itemIn.getEnergyCapability());
            this.holder = LazyOptional.of(() -> this);
        }

        public ImmutableList<BlockPos> getAreaEffectBlocks(BlockPos pos, Player player) {
            return AreaEffectHelper.getBucketableBlocksRadius((ItemStack)this.container, (BlockPos)pos, (Player)player, (int)RFPumpItem.this.getMode(this.container));
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY) {
                return CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

