/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.common.item;

import cofh.core.common.item.IMultiModeItem;
import cofh.core.compat.curios.CuriosProxy;
import cofh.core.util.ProxyUtils;
import cofh.lib.api.item.IColorableItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.lib.common.item.EnergyContainerItemAugmentable;
import cofh.thermal.lib.common.item.IFlexibleEnergyContainerItem;
import cofh.thermal.lib.util.ThermalAugmentRules;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class RFCapacitorItem
extends EnergyContainerItemAugmentable
implements IColorableItem,
DyeableLeatherItem,
IMultiModeItem,
IFlexibleEnergyContainerItem {
    protected static final int EQUIPMENT = 0;
    protected static final int INVENTORY = 1;

    public RFCapacitorItem(Item.Properties builder, int maxEnergy, int maxTransfer) {
        super(builder, maxEnergy, maxTransfer);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("color"), (stack, world, entity, seed) -> this.m_41113_(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("state"), (stack, world, entity, seed) -> (this.isActive(stack) ? 0.5f : 0.0f) + (float)this.getMode(stack) / 8.0f);
        ProxyUtils.registerColorable((Item)this);
        this.numSlots = () -> ThermalCoreConfig.storageAugments;
        this.augValidator = ThermalAugmentRules.ENERGY_STORAGE_VALIDATOR;
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)(this.isActive(stack) ? Component.m_237115_((String)"info.cofh_use_sneak_deactivate").m_130940_(ChatFormatting.DARK_GRAY) : Component.m_237115_((String)"info.cofh.use_sneak_activate").m_130940_(ChatFormatting.DARK_GRAY)));
        tooltip.add((Component)StringHelper.getTextComponent((String)("info.thermal.capacitor.mode." + this.getMode(stack))).m_130940_(ChatFormatting.ITALIC));
        this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        return this.useDelegate(stack, playerIn) ? InteractionResultHolder.m_19090_((Object)stack) : InteractionResultHolder.m_19098_((Object)stack);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return this.useDelegate(stack, context.m_43723_()) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (Utils.isClientWorld((Level)worldIn) || Utils.isFakePlayer((Entity)entityIn) || !this.isActive(stack)) {
            return;
        }
        Player player = (Player)entityIn;
        Iterable equipment = switch (this.getMode(stack)) {
            case 0 -> player.m_20158_();
            case 1 -> player.f_36093_.f_35974_;
            default -> Iterables.concat(Arrays.asList(player.f_36093_.f_35974_, player.f_36093_.f_35975_, player.f_36093_.f_35976_));
        };
        int extract = this.getExtract(stack);
        for (ItemStack equip : equipment) {
            if (equip.m_41619_() || equip.equals(stack)) continue;
            equip.getCapability(ThermalEnergyHelper.getBaseEnergySystem(), null).ifPresent(e -> this.extractEnergy(stack, e.receiveEnergy(Math.min(extract, this.getEnergyStored(stack)), false), player.f_36077_.f_35937_));
        }
        if (this.getMode(stack) != 1) {
            CuriosProxy.getAllWorn((LivingEntity)player).ifPresent(c -> {
                for (int i = 0; i < c.getSlots(); ++i) {
                    ItemStack equip = c.getStackInSlot(i);
                    if (equip.m_41619_() || equip.equals(stack)) continue;
                    equip.getCapability(ThermalEnergyHelper.getBaseEnergySystem(), null).ifPresent(e -> this.extractEnergy(stack, e.receiveEnergy(Math.min(extract, this.getEnergyStored(stack)), false), player.f_36077_.f_35937_));
                }
            });
        }
    }

    protected boolean useDelegate(ItemStack stack, Player player) {
        if (Utils.isFakePlayer((Entity)player)) {
            return false;
        }
        if (player.m_36341_()) {
            this.setActive(stack, !this.isActive(stack));
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.2f, this.isActive(stack) ? 0.8f : 0.5f);
            return true;
        }
        return false;
    }

    public int getNumModes(ItemStack stack) {
        return 3;
    }

    public void onModeChange(Player player, ItemStack stack) {
        player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_12088_, SoundSource.PLAYERS, 0.4f, (this.isActive(stack) ? 0.7f : 0.5f) + 0.1f * (float)this.getMode(stack));
        ProxyUtils.setOverlayMessage((Player)player, (Component)Component.m_237115_((String)("info.thermal.capacitor.mode." + this.getMode(stack))));
    }
}

