/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.network.messages.s2c;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.utils.ClientUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record OpenTempadScreenPacket(List<LocationData> locationData, UUID favorite) implements Packet<OpenTempadScreenPacket>
{
    public static Handler HANDLER = new Handler();
    public static final ResourceLocation ID = new ResourceLocation("tempad", "open_screen");

    public ResourceLocation getID() {
        return ID;
    }

    public PacketHandler<OpenTempadScreenPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<OpenTempadScreenPacket> {
        private Handler() {
        }

        public void encode(OpenTempadScreenPacket message, FriendlyByteBuf buffer) {
            buffer.m_236828_(message.locationData, (buf, locationData) -> {
                buf.m_130077_(locationData.getId());
                buf.m_130070_(locationData.getName());
                buf.m_130064_(locationData.getBlockPos());
                buf.m_236858_(locationData.getLevelKey());
                buf.writeBoolean(locationData.isTeleportable());
                buf.writeBoolean(locationData.isDeletable());
                buf.writeBoolean(locationData.isDownloadable());
            });
            buffer.m_236835_(Optional.ofNullable(message.favorite), FriendlyByteBuf::m_130077_);
        }

        public OpenTempadScreenPacket decode(FriendlyByteBuf buffer) {
            return new OpenTempadScreenPacket(buffer.m_236845_(buf -> {
                UUID id = buf.m_130259_();
                String name = buf.m_130277_();
                BlockPos pos = buf.m_130135_();
                ResourceKey levelResourceKey = buf.m_236801_(Registries.f_256858_);
                boolean teleportable = buf.readBoolean();
                boolean deletable = buf.readBoolean();
                boolean downloadable = buf.readBoolean();
                return new LocationData(name, (ResourceKey<Level>)levelResourceKey, pos, id, teleportable, deletable, downloadable);
            }), buffer.m_236860_(FriendlyByteBuf::m_130259_).orElse(null));
        }

        public PacketContext handle(OpenTempadScreenPacket message) {
            return (player, level) -> ClientUtils.openScreen(message);
        }
    }
}

