/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.api.options;

import java.util.HashMap;
import java.util.Map;
import me.codexadrian.tempad.api.options.TempadOption;
import me.codexadrian.tempad.api.options.impl.ExperienceLevelOption;
import me.codexadrian.tempad.api.options.impl.ExperiencePointsOption;
import me.codexadrian.tempad.api.options.impl.ItemOption;
import me.codexadrian.tempad.api.options.impl.TimerOption;
import me.codexadrian.tempad.api.options.impl.UnlimitedOption;
import me.codexadrian.tempad.common.items.TempadItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TempadOptionApi {
    public static final Map<String, TempadOption> OPTION_REGISTRY = new HashMap<String, TempadOption>();

    public static TempadOption getOption(String id) {
        return OPTION_REGISTRY.getOrDefault(id, new TimerOption());
    }

    public static int getFuelCost(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof TempadItem) {
            TempadItem tempadItem = (TempadItem)item;
            return tempadItem.getFuelCost();
        }
        return 0;
    }

    public static int getFuelCapacity(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof TempadItem) {
            TempadItem tempadItem = (TempadItem)item;
            return tempadItem.getFuelCapacity();
        }
        return 0;
    }

    static {
        OPTION_REGISTRY.put("tempad:unlimited", new UnlimitedOption());
        OPTION_REGISTRY.put("tempad:experience_level", new ExperienceLevelOption());
        OPTION_REGISTRY.put("tempad:experience_points", new ExperiencePointsOption());
        OPTION_REGISTRY.put("tempad:item", new ItemOption());
        OPTION_REGISTRY.put("tempad:timer", new TimerOption());
    }
}

