/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events.overrides;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.WallLanternBlock;
import net.mehvahdjukaar.supplementaries.common.events.overrides.AntiqueInkBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.BellChainBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.BlockUseOverride;
import net.mehvahdjukaar.supplementaries.common.events.overrides.ClockItemBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.CompassItemBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.DirectionalCakeConversionBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.DoubleCakeBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.DyeBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.FDStickBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.ItemUseOnBlockOverride;
import net.mehvahdjukaar.supplementaries.common.events.overrides.ItemUseOverride;
import net.mehvahdjukaar.supplementaries.common.events.overrides.MapMarkerBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.SkullCandlesBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.SkullPileBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.SoapBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.ThrowableBricksBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.WrenchBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.WrittenBookHackBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.XPBottlingBehavior;
import net.mehvahdjukaar.supplementaries.common.items.additional_placements.SuppAdditionalPlacement;
import net.mehvahdjukaar.supplementaries.common.items.additional_placements.WallLanternPlacement;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class InteractEventOverrideHandler {
    private static final Map<Item, ItemUseOnBlockOverride> ITEM_USE_ON_BLOCK_HP = new IdentityHashMap<Item, ItemUseOnBlockOverride>();
    private static final Map<Item, ItemUseOnBlockOverride> ITEM_USE_ON_BLOCK = new IdentityHashMap<Item, ItemUseOnBlockOverride>();
    private static final Map<Item, ItemUseOverride> ITEM_USE = new IdentityHashMap<Item, ItemUseOverride>();
    private static final Map<Block, BlockUseOverride> BLOCK_USE = new IdentityHashMap<Block, BlockUseOverride>();

    public static boolean hasBlockPlacementAssociated(Item item) {
        ItemUseOnBlockOverride v = ITEM_USE_ON_BLOCK.getOrDefault(item, ITEM_USE_ON_BLOCK_HP.get(item));
        return v != null && v.placesBlock();
    }

    public static void init() {
        if (CommonConfigs.Tweaks.WRITTEN_BOOKS.get().booleanValue()) {
            AdditionalItemPlacementsAPI.register(() -> new SuppAdditionalPlacement(ModRegistry.BOOK_PILE_H.get()), () -> Items.f_42614_);
            AdditionalItemPlacementsAPI.register(() -> new SuppAdditionalPlacement(ModRegistry.BOOK_PILE_H.get()), () -> Items.f_42615_);
        }
        if (CommonConfigs.Tweaks.PLACEABLE_BOOKS.get().booleanValue()) {
            AdditionalItemPlacementsAPI.register(() -> new SuppAdditionalPlacement(ModRegistry.BOOK_PILE.get()), CompatObjects.TOME);
            AdditionalItemPlacementsAPI.register(() -> new SuppAdditionalPlacement(ModRegistry.BOOK_PILE.get()), CompatObjects.GENE_BOOK);
        }
        if (CommonConfigs.Tweaks.WALL_LANTERN_PLACEMENT.get().booleanValue()) {
            AdditionalItemPlacementsAPI.register(b -> new WallLanternPlacement(((BlockItem)b).m_40614_()), i -> {
                if (i instanceof BlockItem) {
                    BlockItem bi = (BlockItem)i;
                    Block b = bi.m_40614_();
                    if (b == null) {
                        throw new AssertionError((Object)("Some mod managed to create a block item with null block. WTF. Block: " + bi));
                    }
                    return WallLanternBlock.isValidBlock(b);
                }
                return false;
            });
        }
    }

    public static void setupOverrides() {
        ITEM_USE_ON_BLOCK.clear();
        ITEM_USE_ON_BLOCK_HP.clear();
        ITEM_USE.clear();
        BLOCK_USE.clear();
        ArrayList<ItemUseOnBlockOverride> itemUseOnBlockHP = new ArrayList<ItemUseOnBlockOverride>();
        ArrayList<ItemUseOnBlockOverride> itemUseOnBlock = new ArrayList<ItemUseOnBlockOverride>();
        ArrayList<ItemUseOverride> itemUse = new ArrayList<ItemUseOverride>();
        ArrayList<BlockUseOverride> blockUse = new ArrayList<BlockUseOverride>();
        blockUse.add(new DirectionalCakeConversionBehavior());
        blockUse.add(new BellChainBehavior());
        blockUse.add(new FDStickBehavior());
        itemUse.add(new ThrowableBricksBehavior());
        itemUse.add(new ClockItemBehavior());
        itemUse.add(new CompassItemBehavior());
        itemUseOnBlockHP.add(new AntiqueInkBehavior());
        itemUseOnBlockHP.add(new SoapBehavior());
        itemUseOnBlockHP.add(new DyeBehavior());
        itemUseOnBlockHP.add(new WrenchBehavior());
        itemUseOnBlockHP.add(new SkullCandlesBehavior());
        itemUseOnBlock.add(new SkullPileBehavior());
        itemUseOnBlock.add(new DoubleCakeBehavior());
        itemUseOnBlock.add(new WrittenBookHackBehavior());
        itemUseOnBlock.add(new MapMarkerBehavior());
        itemUseOnBlock.add(new XPBottlingBehavior());
        block0: for (Item i : BuiltInRegistries.f_257033_) {
            for (ItemUseOnBlockOverride itemUseOnBlockOverride : itemUseOnBlock) {
                if (!itemUseOnBlockOverride.appliesToItem(i)) continue;
                ITEM_USE_ON_BLOCK.put(i, itemUseOnBlockOverride);
                continue block0;
            }
            for (ItemUseOverride itemUseOverride : itemUse) {
                if (!itemUseOverride.appliesToItem(i)) continue;
                ITEM_USE.put(i, itemUseOverride);
                continue block0;
            }
            for (ItemUseOnBlockOverride itemUseOnBlockOverride : itemUseOnBlockHP) {
                if (!itemUseOnBlockOverride.appliesToItem(i)) continue;
                ITEM_USE_ON_BLOCK_HP.put(i, itemUseOnBlockOverride);
                continue block0;
            }
        }
        block4: for (Block block : BuiltInRegistries.f_256975_) {
            for (BlockUseOverride blockUseOverride : blockUse) {
                if (!blockUseOverride.appliesToBlock(block)) continue;
                BLOCK_USE.put(block, blockUseOverride);
                continue block4;
            }
        }
    }

    public static InteractionResult onItemUsedOnBlockHP(Player player, Level level, ItemStack stack, InteractionHand hand, BlockHitResult hit) {
        Item item = stack.m_41720_();
        ItemUseOnBlockOverride override = ITEM_USE_ON_BLOCK_HP.get(item);
        if (override != null && override.isEnabled()) {
            if (CompatHandler.FLAN && override.altersWorld() && !FlanCompat.canPlace(player, hit.m_82425_())) {
                return InteractionResult.PASS;
            }
            if (override.altersWorld() && !Utils.mayBuild((Player)player, (BlockPos)hit.m_82425_())) {
                return InteractionResult.PASS;
            }
            return override.tryPerformingAction(level, player, hand, stack, hit);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult onItemUsedOnBlock(Player player, Level level, ItemStack stack, InteractionHand hand, BlockHitResult hit) {
        BlockPos pos;
        BlockState state;
        BlockUseOverride o;
        Item item = stack.m_41720_();
        ItemUseOnBlockOverride override = ITEM_USE_ON_BLOCK.get(item);
        if (override != null && override.isEnabled()) {
            if (CompatHandler.FLAN && override.altersWorld() && !FlanCompat.canPlace(player, hit.m_82425_())) {
                return InteractionResult.PASS;
            }
            if (override.altersWorld() && !Utils.mayBuild((Player)player, (BlockPos)hit.m_82425_())) {
                return InteractionResult.PASS;
            }
            InteractionResult result = override.tryPerformingAction(level, player, hand, stack, hit);
            if (result != InteractionResult.PASS) {
                return result;
            }
        }
        if (!player.m_6144_() && (o = BLOCK_USE.get((state = level.m_8055_(pos = hit.m_82425_())).m_60734_())) != null && o.isEnabled()) {
            if (CompatHandler.FLAN && o.altersWorld() && !FlanCompat.canPlace(player, hit.m_82425_())) {
                return InteractionResult.PASS;
            }
            return o.tryPerformingAction(state, pos, level, player, hand, stack, hit);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResultHolder<ItemStack> onItemUse(Player player, Level level, InteractionHand hand, ItemStack stack) {
        Item item = stack.m_41720_();
        ItemUseOverride override = ITEM_USE.get(item);
        if (override != null && override.isEnabled()) {
            InteractionResult ret = override.tryPerformingAction(level, player, hand, stack, null);
            return switch (ret) {
                case InteractionResult.CONSUME -> InteractionResultHolder.m_19096_((Object)stack);
                case InteractionResult.SUCCESS -> InteractionResultHolder.m_19090_((Object)stack);
                default -> InteractionResultHolder.m_19098_((Object)stack);
                case InteractionResult.FAIL -> InteractionResultHolder.m_19100_((Object)stack);
            };
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public static void addOverrideTooltips(ItemStack itemStack, TooltipFlag tooltipFlag, List<Component> components) {
        Item item = itemStack.m_41720_();
        ItemUseOnBlockOverride override = ITEM_USE_ON_BLOCK.get(item);
        if (override != null && override.isEnabled()) {
            MutableComponent t = override.getTooltip();
            if (t != null) {
                components.add((Component)t.m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
            }
        } else {
            MutableComponent t;
            ItemUseOverride o = ITEM_USE.get(item);
            if (o != null && o.isEnabled() && (t = o.getTooltip()) != null) {
                components.add((Component)t.m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
            }
        }
    }

    public static InteractionResult replaceSimilarBlock(Block blockOverride, Player player, ItemStack stack, BlockPos pos, Level level, BlockState replaced, @Nullable SoundType sound, Property<?> ... properties) {
        BlockState newState = blockOverride.m_49966_();
        for (Property<?> p : properties) {
            newState = BlockUtil.replaceProperty(replaced, newState, p);
        }
        if (newState.m_61138_((Property)BlockStateProperties.f_61362_)) {
            FluidState fluidstate = level.m_6425_(pos);
            newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8));
        }
        if (!level.m_7731_(pos, newState, 3)) {
            return InteractionResult.FAIL;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.f_10591_.m_285767_(serverPlayer, pos, stack);
        }
        level.m_142346_((Entity)player, GameEvent.f_157797_, pos);
        if (sound == null) {
            sound = newState.m_60827_();
        }
        level.m_5594_(player, pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
        if (player == null || !player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }
}

