/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.forge;

import java.util.ArrayList;
import java.util.Arrays;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.supplementaries.api.forge.RedMerchantTradesEvent;
import net.mehvahdjukaar.supplementaries.common.capabilities.CapabilityHandler;
import net.mehvahdjukaar.supplementaries.mixins.forge.MobBucketItemAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class SuppPlatformStuffImpl {
    public static EntityType<?> getFishType(MobBucketItem bucketItem) {
        return ((MobBucketItemAccessor)bucketItem).invokeGetFishType();
    }

    @Nullable
    public static <T> T getForgeCap(Object object, Class<T> capClass) {
        Capability<T> t = CapabilityHandler.getToken(capClass);
        if (t != null && object instanceof ICapabilityProvider) {
            ICapabilityProvider cp = (ICapabilityProvider)object;
            return CapabilityHandler.get(cp, t);
        }
        return null;
    }

    @Nullable
    public static BlockState getUnoxidised(Level level, BlockPos pos, BlockState state) {
        BlockState newMod;
        Player fp = FakePlayerManager.getDefault((Level)level);
        fp.m_21008_(InteractionHand.MAIN_HAND, Items.f_42386_.m_7968_());
        Block b = state.m_60734_();
        UseOnContext context = new UseOnContext(fp, InteractionHand.MAIN_HAND, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.UP, pos, false));
        BlockState modified = state;
        modified = b.getToolModifiedState(modified, context, ToolActions.AXE_WAX_OFF, false);
        if (modified == null) {
            modified = state;
        }
        while ((newMod = b.getToolModifiedState(modified, context, ToolActions.AXE_SCRAPE, false)) != null && newMod != modified) {
            modified = newMod;
        }
        if (modified == state) {
            return null;
        }
        return modified;
    }

    public static boolean isEndermanMask(EnderMan enderMan, Player player, ItemStack itemstack) {
        try {
            return itemstack.isEnderMask(player, enderMan);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getItemLifeSpawn(ItemEntity itemEntity) {
        return itemEntity.lifespan;
    }

    public static void onItemPickup(Player player, ItemEntity itemEntity, ItemStack copy) {
        ForgeEventFactory.firePlayerItemPickupEvent((Player)player, (ItemEntity)itemEntity, (ItemStack)copy);
    }

    public static CreativeModeTab.Builder searchBar(CreativeModeTab.Builder c) {
        return c.withSearchBar();
    }

    public static float getDownfall(Biome biome) {
        return biome.getModifiedClimateSettings().f_47683_();
    }

    public static VillagerTrades.ItemListing[] fireRedMerchantTradesEvent(VillagerTrades.ItemListing[] listings) {
        RedMerchantTradesEvent event = new RedMerchantTradesEvent(new ArrayList<VillagerTrades.ItemListing>(Arrays.stream(listings).toList()));
        MinecraftForge.EVENT_BUS.post((Event)event);
        return (VillagerTrades.ItemListing[])event.getTrades().toArray(VillagerTrades.ItemListing[]::new);
    }
}

