/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.misc.WeakHashSet;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.mehvahdjukaar.supplementaries.reg.ModWorldgenRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class WaySignStructure
extends Structure {
    public static final Codec<WaySignStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WaySignStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.INT.fieldOf("min_y").forGetter(structure -> structure.minY), (App)Codec.INT.fieldOf("max_y").forGetter(structure -> structure.maxY)).apply((Applicative)instance, WaySignStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int minY;
    private final int maxY;
    private static final Set<Holder<Biome>> VALID_BIOMES = new WeakHashSet();

    public WaySignStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int minY, int maxY) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.minY = minY;
        this.maxY = maxY;
    }

    public StructureType<?> m_213658_() {
        return ModWorldgenRegistry.WAY_SIGN.get();
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        Optional<BlockPos> suitablePosition = WaySignStructure.getSuitablePosition(context, this);
        if (suitablePosition.isEmpty()) {
            return Optional.empty();
        }
        BlockPos blockPos = suitablePosition.get();
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)3, (BlockPos)blockPos, (boolean)false, Optional.empty(), (int)32);
    }

    private static Optional<BlockPos> getSuitablePosition(Structure.GenerationContext context, WaySignStructure structure) {
        int z;
        ChunkPos chunkPos = context.f_226628_();
        ChunkGenerator generator = context.f_226622_();
        LevelHeightAccessor levelHeightAccessor = context.f_226629_();
        RandomState randomState = context.f_226624_();
        Set biomes = context.f_226623_().m_207840_();
        boolean hasVillages = false;
        for (Holder<Biome> v : VALID_BIOMES) {
            if (!biomes.contains(v)) continue;
            hasVillages = true;
            break;
        }
        if (!hasVillages) {
            return Optional.empty();
        }
        int x = chunkPos.m_151390_();
        int y = generator.m_223235_(x, z = chunkPos.m_151393_(), Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, randomState);
        if (y < structure.minY || y > structure.maxY) {
            return Optional.empty();
        }
        if (y > 105 || y < generator.m_6337_()) {
            return Optional.empty();
        }
        IntArrayList list = new IntArrayList();
        list.add(y);
        if (WaySignStructure.isPosNotValid(generator, x + 2, z + 2, (IntList)list, levelHeightAccessor, randomState)) {
            return Optional.empty();
        }
        if (WaySignStructure.isPosNotValid(generator, x + 2, z - 2, (IntList)list, levelHeightAccessor, randomState)) {
            return Optional.empty();
        }
        if (WaySignStructure.isPosNotValid(generator, x - 2, z + 2, (IntList)list, levelHeightAccessor, randomState)) {
            return Optional.empty();
        }
        if (WaySignStructure.isPosNotValid(generator, x - 2, z - 2, (IntList)list, levelHeightAccessor, randomState)) {
            return Optional.empty();
        }
        IntRBTreeSet set = new IntRBTreeSet((IntCollection)list);
        if (set.lastInt() - set.firstInt() > 1) {
            return Optional.empty();
        }
        int sum = 0;
        for (Integer v : list) {
            sum += v.intValue();
        }
        return Optional.of(new BlockPos(x, Math.round((float)sum / 5.0f) + 1, z));
    }

    private static boolean isPosNotValid(ChunkGenerator gen, int x, int z, IntList heightMap, LevelHeightAccessor heightLimitView, RandomState randomState) {
        int y = gen.m_223235_(x, z, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, randomState);
        NoiseColumn noisecolumn = gen.m_214184_(x, z, heightLimitView, randomState);
        BlockState state = noisecolumn.m_183556_(y);
        try {
            if (state.m_60819_().m_76178_()) {
                heightMap.add(y);
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public static void recomputeValidStructureCache(RegistryAccess access) {
        for (Holder s : access.m_175515_(Registries.f_256944_).m_206058_(ModTags.WAY_SIGN_DESTINATIONS)) {
            VALID_BIOMES.addAll(((Structure)s.m_203334_()).m_226559_().m_203614_().toList());
        }
    }

    public static void clearCache() {
        VALID_BIOMES.clear();
    }

    public static class Type
    implements StructureType<WaySignStructure> {
        public Codec<WaySignStructure> m_226884_() {
            return CODEC;
        }
    }
}

