/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ServerBoundCycleQuiverPacket
implements Message {
    private final int amount;
    private final Slot slot;
    private final boolean setSlot;

    public ServerBoundCycleQuiverPacket(FriendlyByteBuf buf) {
        this.amount = buf.readInt();
        this.slot = Slot.values()[buf.readInt()];
        this.setSlot = buf.readBoolean();
    }

    public ServerBoundCycleQuiverPacket(int amount, Slot slot, boolean setSlot) {
        this.amount = amount;
        this.slot = slot;
        this.setSlot = setSlot;
    }

    public ServerBoundCycleQuiverPacket(int amount, Slot slot) {
        this(amount, slot, false);
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.writeInt(this.amount);
        buf.writeInt(this.slot.ordinal());
        buf.writeBoolean(this.setSlot);
    }

    public void handle(ChannelHandler.Context context) {
        ServerPlayer player = (ServerPlayer)Objects.requireNonNull(context.getSender());
        ItemStack stack = ItemStack.f_41583_;
        if (this.slot == Slot.INVENTORY) {
            stack = QuiverItem.getQuiver((LivingEntity)player);
        } else if (player.m_7655_() == InteractionHand.MAIN_HAND == (this.slot == Slot.MAIN_HAND)) {
            stack = player.m_21211_();
        }
        if (stack.m_41720_() != ModRegistry.QUIVER_ITEM.get()) {
            boolean bl = true;
        } else {
            QuiverItem.Data data = QuiverItem.getQuiverData(stack);
            if (this.setSlot) {
                data.setSelectedSlot(this.amount);
            } else {
                data.cycle(this.amount);
            }
        }
    }

    public static enum Slot {
        MAIN_HAND,
        OFF_HAND,
        INVENTORY;

    }
}

