/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.TrappedPresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.present.IPresentItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.tiles.AbstractPresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.TrappedPresentContainerMenu;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TrappedPresentBlockTile
extends AbstractPresentBlockTile {
    public TrappedPresentBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.TRAPPED_PRESENT_TILE.get(), pos, state);
    }

    @Override
    public boolean canHoldItems() {
        return this.isPrimed();
    }

    public static boolean isPrimed(ItemStack stack) {
        CompoundTag com = stack.m_41783_();
        if (com != null) {
            CompoundTag tag = com.m_128469_("BlockEntityTag");
            return tag.m_128441_("Items");
        }
        return false;
    }

    public boolean isPrimed() {
        return (Boolean)this.m_58900_().m_61143_((Property)TrappedPresentBlock.PACKED);
    }

    public void updateState(boolean primed) {
        if (!this.f_58857_.f_46443_ && this.isPrimed() != primed) {
            if (primed) {
                this.f_58857_.m_5594_(null, this.f_58858_, ModSounds.PRESENT_PACK.get(), SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.95f);
            } else {
                this.f_58857_.m_5594_(null, this.f_58858_, ModSounds.PRESENT_BREAK.get(), SoundSource.BLOCKS, 0.75f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 1.2f);
            }
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)TrappedPresentBlock.PACKED, (Comparable)Boolean.valueOf(primed)), 3);
        }
    }

    public boolean m_7525_(Player player) {
        if (!super.m_7525_(player)) {
            return false;
        }
        if (!this.isUnused()) {
            return false;
        }
        return !this.isPrimed();
    }

    @Override
    public InteractionResult interact(Level level, BlockPos pos, BlockState state, Player player) {
        if (((Boolean)state.m_61143_((Property)TrappedPresentBlock.ON_COOLDOWN)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        if (this.isUnused()) {
            if (this.m_7525_(player)) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PlatHelper.openCustomMenu((ServerPlayer)serverPlayer, (MenuProvider)this, (BlockPos)pos);
                    PiglinAi.m_34873_((Player)player, (boolean)true);
                }
            } else {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)TrappedPresentBlock.ON_COOLDOWN, (Comparable)Boolean.valueOf(true)));
                level.m_186460_(pos, state.m_60734_(), 10);
                if (level instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    this.detonate(sl, pos);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void detonate(ServerLevel level, BlockPos pos) {
        BlockSourceImpl blocksourceimpl = new BlockSourceImpl(level, pos);
        ItemStack stack = this.m_8020_(0);
        IPresentItemBehavior presentItemBehavior = TrappedPresentBlock.getPresentBehavior(stack);
        this.updateState(false);
        presentItemBehavior.trigger((BlockSource)blocksourceimpl, stack);
    }

    public Component m_6820_() {
        return Component.m_237115_((String)"gui.supplementaries.trapped_present");
    }

    @Override
    public AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new TrappedPresentContainerMenu(id, player, this);
    }

    public int m_6893_() {
        return 1;
    }
}

