/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.present;

import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.TrappedPresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.present.IPresentItemBehavior;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.entities.HatStandEntity;
import net.mehvahdjukaar.supplementaries.common.items.BombItem;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendKnockbackPacket;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PresentBehaviorsManager {
    private static final IPresentItemBehavior SPAWN_EGG_BEHAVIOR = (source, stack) -> {
        EntityType type = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
        try {
            ServerLevel level = source.m_7727_();
            BlockPos pos = source.m_7961_();
            Object e = PresentBehaviorsManager.spawnMob(type, level, source, stack);
            if (e != null) {
                stack.m_41774_(1);
                level.m_142346_(null, GameEvent.f_157810_, pos);
                return Optional.of(stack);
            }
        }
        catch (Exception exception) {
            Supplementaries.LOGGER.error("Error while dispensing spawn egg from trapped present at {}", (Object)source.m_7961_(), (Object)exception);
        }
        return Optional.empty();
    };
    private static final IPresentItemBehavior SKIBIDI_BEHAVIOR = (source, stack) -> {
        EntityType<HatStandEntity> type = ModEntities.HAT_STAND.get();
        try {
            ServerLevel level = source.m_7727_();
            BlockPos pos = source.m_7961_();
            HatStandEntity e = PresentBehaviorsManager.spawnMob(type, level, source, stack);
            if (e != null) {
                stack.m_41774_(1);
                level.m_142346_(null, GameEvent.f_157810_, pos);
                e.setSkibidi(true, false);
                return Optional.of(stack);
            }
        }
        catch (Exception exception) {
            Supplementaries.LOGGER.error("Error while dispensing spawn egg from trapped present at {}", (Object)source.m_7961_(), (Object)exception);
        }
        return Optional.empty();
    };
    private static final IPresentItemBehavior TNT_BEHAVIOR = (source, stack) -> {
        BlockItem bi;
        Block patt5341$temp;
        ServerLevel level = source.m_7727_();
        BlockPos blockpos = source.m_7961_().m_7494_();
        Item patt5300$temp = stack.m_41720_();
        if (patt5300$temp instanceof BlockItem && (patt5341$temp = (bi = (BlockItem)patt5300$temp).m_40614_()) instanceof TntBlock) {
            TntBlock tnt = (TntBlock)patt5341$temp;
            Explosion dummyExplosion = new Explosion((Level)level, null, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123341_() + 0.5, 0.0f, false, Explosion.BlockInteraction.KEEP);
            tnt.m_7592_((Level)level, blockpos, dummyExplosion);
            List entities = level.m_45976_(PrimedTnt.class, new AABB(blockpos).m_82386_(0.0, 0.5, 0.0));
            for (PrimedTnt e : entities) {
                Vec3 p = e.m_20182_();
                e.m_146884_(new Vec3(p.f_82479_, (double)((float)blockpos.m_123342_() + 0.625f), p.f_82481_));
            }
            level.m_142346_(null, GameEvent.f_157810_, blockpos);
            stack.m_41774_(1);
            return Optional.of(stack);
        }
        return Optional.empty();
    };
    private static final IPresentItemBehavior FIREWORK_BEHAVIOR = new IPresentItemBehavior(){

        @Override
        public Optional<ItemStack> performSpecialAction(BlockSource source, ItemStack stack) {
            ServerLevel level = source.m_7727_();
            Position p = IPresentItemBehavior.getDispensePosition(source);
            FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity((Level)level, stack, p.m_7096_(), p.m_7098_(), p.m_7094_(), true);
            fireworkrocketentity.m_6686_(0.0, 1.0, 0.0, 0.5f, 1.0f);
            level.m_7967_((Entity)fireworkrocketentity);
            stack.m_41774_(1);
            return Optional.of(stack);
        }

        @Override
        public void playAnimation(BlockSource pSource) {
            IPresentItemBehavior.super.playAnimation(pSource);
            pSource.m_7727_().m_46796_(1004, pSource.m_7961_(), 0);
        }
    };
    private static final AbstractProjectileBehavior SPLASH_POTION_BEHAVIOR = new AbstractProjectileBehavior(){

        @Override
        protected Projectile getProjectile(Level worldIn, Position position, ItemStack stackIn) {
            return (Projectile)Util.m_137469_((Object)new ThrownPotion(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_()), potion -> potion.m_37446_(stackIn));
        }

        @Override
        protected float getPower() {
            return 0.5f;
        }

        @Override
        protected float getUncertainty() {
            return 11.0f;
        }
    };
    private static final AbstractProjectileBehavior BOMB_BEHAVIOR = new AbstractProjectileBehavior(){

        @Override
        protected Projectile getProjectile(Level worldIn, Position position, ItemStack stackIn) {
            return new BombEntity(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_(), ((BombItem)stackIn.m_41720_()).getType());
        }

        @Override
        protected float getUncertainty() {
            return 11.0f;
        }
    };

    public static void registerBehaviors() {
        for (Item i : BuiltInRegistries.f_257033_) {
            BlockItem bi;
            if (i instanceof BlockItem && (bi = (BlockItem)i).m_40614_() instanceof TntBlock) {
                TrappedPresentBlock.registerBehavior((ItemLike)i, TNT_BEHAVIOR);
            }
            if (!(i instanceof SpawnEggItem)) continue;
            SpawnEggItem sp = (SpawnEggItem)i;
            TrappedPresentBlock.registerBehavior((ItemLike)sp, SPAWN_EGG_BEHAVIOR);
        }
        TrappedPresentBlock.registerBehavior((ItemLike)Items.f_42688_, FIREWORK_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((ItemLike)Items.f_42736_, SPLASH_POTION_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((ItemLike)Items.f_42739_, SPLASH_POTION_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((ItemLike)ModRegistry.BOMB_ITEM.get(), BOMB_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((ItemLike)ModRegistry.BOMB_ITEM_ON.get(), BOMB_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((ItemLike)ModRegistry.BOMB_BLUE_ITEM.get(), BOMB_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((ItemLike)ModRegistry.BOMB_BLUE_ITEM_ON.get(), BOMB_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((ItemLike)ModRegistry.BOMB_SPIKY_ITEM.get(), BOMB_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((ItemLike)ModRegistry.BOMB_SPIKY_ITEM_ON.get(), BOMB_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((ItemLike)ModRegistry.HAT_STAND.get(), SKIBIDI_BEHAVIOR);
    }

    @Nullable
    private static <T extends Entity> T spawnMob(EntityType<T> entityType, ServerLevel serverLevel, BlockSource source, @Nullable ItemStack stack) {
        BlockPos pos = source.m_7961_();
        CompoundTag tag = stack == null ? null : stack.m_41783_();
        Component component = stack != null && stack.m_41788_() ? stack.m_41786_() : null;
        Entity entity = entityType.m_20615_((Level)serverLevel);
        if (entity != null) {
            if (component != null) {
                entity.m_6593_(component);
            }
            EntityType.m_20620_((Level)serverLevel, null, (Entity)entity, (CompoundTag)tag);
            Position p = IPresentItemBehavior.getDispensePosition(source);
            entity.m_6034_(p.m_7096_(), p.m_7098_(), p.m_7094_());
            entity.m_7678_(p.m_7096_(), p.m_7098_(), p.m_7094_(), Mth.m_14177_((float)(serverLevel.f_46441_.m_188501_() * 360.0f)), 0.0f);
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, 0.3, 0.0));
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.f_20885_ = mob.m_146908_();
                mob.f_20883_ = mob.m_146908_();
                mob.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(mob.m_20183_()), MobSpawnType.DISPENSER, null, tag);
                mob.m_8032_();
            }
            serverLevel.m_47205_(entity);
            NetworkHandler.CHANNEL.sendToAllClientPlayersInRange((Level)serverLevel, pos, 48.0, (Message)new ClientBoundSendKnockbackPacket(entity.m_20184_(), entity.m_19879_()));
        }
        return (T)entity;
    }

    public static abstract class AbstractProjectileBehavior
    implements IPresentItemBehavior {
        @Override
        public Optional<ItemStack> performSpecialAction(BlockSource source, ItemStack stack) {
            ServerLevel level = source.m_7727_();
            Position position = IPresentItemBehavior.getDispensePosition(source);
            Projectile projectile = this.getProjectile((Level)level, position, stack);
            projectile.m_6686_(0.0, 1.0, 0.0, this.getPower(), this.getUncertainty());
            level.m_7967_((Entity)projectile);
            stack.m_41774_(1);
            return Optional.of(stack);
        }

        protected abstract Projectile getProjectile(Level var1, Position var2, ItemStack var3);

        protected float getUncertainty() {
            return 6.0f;
        }

        protected float getPower() {
            return 0.4f;
        }
    }
}

