/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class QuiverLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
    private final Supplier<QuiverMode> quiverMode;
    private final boolean skeleton;

    public QuiverLayer(RenderLayerParent<T, M> parent, boolean isSkeleton) {
        super(parent);
        this.skeleton = isSkeleton;
        this.quiverMode = isSkeleton ? ClientConfigs.Items.QUIVER_SKELETON_RENDER_MODE : ClientConfigs.Items.QUIVER_RENDER_MODE;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack quiver;
        if (!(livingEntity instanceof IQuiverEntity)) {
            return;
        }
        QuiverMode mode = this.quiverMode.get();
        if (mode == QuiverMode.HIDDEN) {
            return;
        }
        if (!this.skeleton) {
            quiver = ((IQuiverEntity)livingEntity).supplementaries$getQuiver();
            if (livingEntity.m_21205_() == quiver || livingEntity.m_21206_() == quiver) {
                return;
            }
        } else if (((IQuiverEntity)livingEntity).supplementaries$hasQuiver()) {
            quiver = ModRegistry.QUIVER_ITEM.get().m_7968_();
        } else {
            return;
        }
        if (!quiver.m_41619_()) {
            poseStack.m_85836_();
            ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
            boolean flipped = livingEntity.m_5737_() == HumanoidArm.RIGHT;
            double o = 0.001;
            if (mode == QuiverMode.THIGH) {
                boolean hasArmor = livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ArmorItem;
                double offset = hasArmor ? ClientConfigs.Items.QUIVER_ARMOR_OFFSET.get() : 0.0;
                boolean sneaking = livingEntity.m_6047_();
                if (sneaking) {
                    poseStack.m_85837_(0.0, -0.125, -0.275);
                }
                o += offset == -1.0 ? 0.21875 : 0.1875 + offset;
                if (flipped) {
                    float old = ((HumanoidModel)this.m_117386_()).f_102814_.f_104203_;
                    ((HumanoidModel)this.m_117386_()).f_102814_.f_104203_ = old * 0.3f;
                    ((HumanoidModel)this.m_117386_()).f_102814_.m_104299_(poseStack);
                    ((HumanoidModel)this.m_117386_()).f_102814_.f_104203_ = old;
                    poseStack.m_85837_(0.0, -0.0625, -0.15625);
                    poseStack.m_85837_(o, 0.0, 0.0);
                } else {
                    float old = ((HumanoidModel)this.m_117386_()).f_102813_.f_104203_;
                    ((HumanoidModel)this.m_117386_()).f_102813_.f_104203_ = old * 0.3f;
                    ((HumanoidModel)this.m_117386_()).f_102813_.m_104299_(poseStack);
                    ((HumanoidModel)this.m_117386_()).f_102813_.f_104203_ = old;
                    poseStack.m_85837_(0.0, -0.0625, -0.15625);
                    poseStack.m_85837_(-o, 0.0, 0.0);
                }
            } else {
                double offset;
                boolean hasArmor = livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ArmorItem;
                double d = offset = hasArmor ? ClientConfigs.Items.QUIVER_ARMOR_OFFSET.get() : 0.0;
                if (mode == QuiverMode.HIP) {
                    poseStack.m_85837_(0.0, 0.1, o += offset == -1.0 ? 0.21875 : 0.1875 + offset);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                    if (flipped) {
                        poseStack.m_85841_(-1.0f, 1.0f, -1.0f);
                    }
                    poseStack.m_85837_(0.0, 0.4, -0.1875);
                    poseStack.m_252781_(Axis.f_252495_.m_252977_(-22.5f));
                } else {
                    poseStack.m_85837_(0.0, 0.1, o += offset == -1.0 ? 0.25 : 0.1875 + offset);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                    if (flipped) {
                        poseStack.m_85841_(-1.0f, 1.0f, -1.0f);
                    }
                    poseStack.m_85837_(0.0, 0.0, -0.125);
                }
            }
            this.itemRenderer.m_269491_(livingEntity, quiver, ItemDisplayContext.HEAD, false, poseStack, buffer, livingEntity.m_9236_(), packedLight, OverlayTexture.f_118083_, 0);
            poseStack.m_85849_();
        }
    }

    public static enum QuiverMode {
        HIDDEN,
        BACK,
        HIP,
        THIGH;

    }
}

