/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.api.util.Log;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class JavaUtils {
    private JavaUtils() {
    }

    private static Set<Class<?>> getClassesBfs(Class<?> clazz, boolean superClasses, boolean interfaces) {
        LinkedHashSet classes = new LinkedHashSet();
        LinkedHashSet nextLevel = new LinkedHashSet();
        if (!superClasses && !interfaces) {
            return classes;
        }
        nextLevel.add(clazz);
        do {
            classes.addAll(nextLevel);
            LinkedHashSet thisLevel = new LinkedHashSet(nextLevel);
            nextLevel.clear();
            for (Class each : thisLevel) {
                Class superClass = each.getSuperclass();
                if (superClasses && superClass != null && superClass != Object.class) {
                    nextLevel.add(superClass);
                }
                if (!interfaces) continue;
                for (Class<?> eachInt : each.getInterfaces()) {
                    nextLevel.add(eachInt);
                }
            }
        } while (!nextLevel.isEmpty());
        return classes;
    }

    public static List<Class<?>> commonSuperClass(boolean superClasses, boolean interfaces, Class<?> ... classes) {
        if (!superClasses && !interfaces) {
            return new LinkedList();
        }
        LinkedHashSet rollingIntersect = new LinkedHashSet(JavaUtils.getClassesBfs(classes[0], superClasses, interfaces));
        for (int i = 1; i < classes.length; ++i) {
            rollingIntersect.retainAll(JavaUtils.getClassesBfs(classes[i], superClasses, interfaces));
        }
        return new LinkedList(rollingIntersect);
    }

    public static Class<?> getFirstCommonSuperClass(Class<?> ... classes) {
        List<Class<?>> superClasses = JavaUtils.commonSuperClass(true, false, classes);
        return superClasses.isEmpty() ? Object.class : superClasses.get(0);
    }

    public static boolean deleteDirectory(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return true;
        }
        try (Stream<Path> paths = Files.list(path);){
            paths.forEach(child -> {
                if (Files.isDirectory(child, new LinkOption[0])) {
                    JavaUtils.deleteDirectory(child);
                }
                try {
                    Files.deleteIfExists(child);
                }
                catch (Exception e) {
                    Log.getLogger().warn("Failed deleting: " + child, (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            Log.getLogger().warn("Failed deleting: " + path, (Throwable)e);
            return false;
        }
        try {
            return Files.deleteIfExists(path);
        }
        catch (IOException e) {
            Log.getLogger().warn("Failed deleting: " + path, (Throwable)e);
            return false;
        }
    }
}

